/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Amulet;
import com.shatteredpixel.shatteredpixeldungeon.levels.LabsLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class NewLastLevel
extends Level {
    private static int WIDTH = 9;
    private static int HEIGHT = 34;
    public static int AMULET_POS = 40;
    private static final short n = -1;
    private static final short W = 4;
    private static final short e = 1;
    private static final short E = 7;
    private static final short p = 11;
    private static final short s = 14;
    private static final short D = 5;
    private static final short i = 32;
    private static final short t = 33;
    private static final short L = 21;
    private static short[] level = new short[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 33, 33, 33, 33, 33, 4, 4, 4, 4, 33, 33, 33, 33, 33, 4, 4, 4, 4, 33, 33, 11, 33, 33, 4, 4, 4, 4, 33, 33, 33, 33, 33, 4, 4, 4, 4, 33, 33, 33, 33, 33, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 4, 33, 33, 33, 4, 4, 4, 4, 4, 33, 33, 33, 33, 33, 4, 4, 4, 4, 33, 32, 32, 32, 33, 4, 4, 4, 4, 33, 32, 7, 32, 33, 4, 4, 4, 4, 33, 32, 32, 32, 33, 4, 4, 4, 4, 33, 33, 33, 33, 33, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};

    public NewLastLevel() {
        this.color1 = 4748860;
        this.color2 = 5871946;
    }

    @Override
    public String tilesTex() {
        return "environment/tiles_labs.png";
    }

    @Override
    public String waterTex() {
        return "environment/water5.png";
    }

    @Override
    protected boolean build() {
        this.setSize(WIDTH, HEIGHT);
        this.transitions.add(new LevelTransition(this, 274, LevelTransition.Type.REGULAR_ENTRANCE));
        this.buildLevel();
        return true;
    }

    private void buildLevel() {
        int pos = 0 + 0 * this.width();
        short[] levelTiles = level;
        for (int i = 0; i < levelTiles.length; ++i) {
            if (levelTiles[i] != -1) {
                this.map[pos] = levelTiles[i];
            }
            ++pos;
        }
    }

    @Override
    public Mob createMob() {
        return null;
    }

    @Override
    protected void createMobs() {
    }

    @Override
    public Actor addRespawner() {
        return null;
    }

    @Override
    protected void createItems() {
        this.drop(new Amulet(), AMULET_POS);
    }

    @Override
    public int randomRespawnCell(Char ch) {
        int cell;
        while (!this.passable[cell = this.entrance() + PathFinder.NEIGHBOURS8[Random.Int(8)]] || Char.hasProp(ch, Char.Property.LARGE) && !this.openSpace[cell] || Actor.findChar(cell) != null) {
        }
        return cell;
    }

    @Override
    public String tileName(int tile) {
        switch (tile) {
            case 29: {
                return Messages.get(LabsLevel.class, "water_name", new Object[0]);
            }
            case 12: {
                return Messages.get(LabsLevel.class, "wall_deco_name", new Object[0]);
            }
            case 25: {
                return Messages.get(LabsLevel.class, "statue_name", new Object[0]);
            }
            case 32: {
                return Messages.get(LabsLevel.class, "custom_tile_1_name", new Object[0]);
            }
            case 33: {
                return Messages.get(LabsLevel.class, "custom_tile_2_name", new Object[0]);
            }
            case 34: {
                return Messages.get(LabsLevel.class, "custom_tile_3_name", new Object[0]);
            }
            case 21: {
                return Messages.get(LabsLevel.class, "locked_exit_name", new Object[0]);
            }
            case 22: {
                return Messages.get(LabsLevel.class, "unlocked_exit_name", new Object[0]);
            }
        }
        return super.tileName(tile);
    }

    @Override
    public String tileDesc(int tile) {
        switch (tile) {
            case 7: {
                return Messages.get(LabsLevel.class, "entrance_desc", new Object[0]);
            }
            case 8: {
                return Messages.get(LabsLevel.class, "exit_desc", new Object[0]);
            }
            case 20: {
                return Messages.get(LabsLevel.class, "empty_deco_desc", new Object[0]);
            }
            case 12: {
                return Messages.get(LabsLevel.class, "wall_deco_desc", new Object[0]);
            }
            case 27: {
                return Messages.get(LabsLevel.class, "bookshelf_desc", new Object[0]);
            }
            case 25: {
                return Messages.get(LabsLevel.class, "statue_desc", new Object[0]);
            }
            case 32: {
                return Messages.get(LabsLevel.class, "custom_tile_1_desc", new Object[0]);
            }
            case 33: {
                return Messages.get(LabsLevel.class, "custom_tile_2_desc", new Object[0]);
            }
            case 34: {
                return Messages.get(LabsLevel.class, "custom_tile_3_desc", new Object[0]);
            }
            case 21: {
                return Messages.get(LabsLevel.class, "locked_exit_desc", new Object[0]);
            }
            case 22: {
                return Messages.get(LabsLevel.class, "unlocked_exit_desc", new Object[0]);
            }
        }
        return super.tileDesc(tile);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        if (bundle.contains("exit")) {
            bundle.remove("exit");
        }
        super.restoreFromBundle(bundle);
    }
}

