/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.Bones;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ConfusionGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.CorrosiveGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ParalyticGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ToxicGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Rebel;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.CrystalKey;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.GoldenKey;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfArmorEnhance;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfWeaponEnhance;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.HandyBarricade;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfEnchantment;
import com.shatteredpixel.shatteredpixeldungeon.levels.LabsLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.tweeners.AlphaTweener;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import com.watabou.utils.Rect;

public class LabsBossLevel
extends Level {
    private static int WIDTH = 33;
    private static int HEIGHT = 40;
    private static final Rect entry = new Rect(0, 27, 33, 6);
    private static final Rect arena = new Rect(0, 0, 33, 26);
    private static final Rect exitDoor = new Rect(16, 1, 16, 1);
    private static final int topDoor = 49;
    private static final int bottomDoor = 16 + (LabsBossLevel.arena.bottom + 1) * 33;
    private static final int bossPos = bottomDoor - 363;
    private static boolean isCompleted = false;
    private static final short n = -1;
    private static final short W = 4;
    private static final short e = 1;
    private static final short E = 7;
    private static final short p = 11;
    private static final short s = 14;
    private static final short D = 5;
    private static final short C = 31;
    private static final short B = 25;
    private static final short i = 32;
    private static final short t = 33;
    private static final short J = 34;
    private static final short L = 21;
    private static short[] level = new short[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 21, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 11, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 32, 32, 32, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 32, 32, 32, 4, 4, 4, 4, 32, 11, 32, 32, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 32, 32, 11, 32, 4, 4, 4, 4, 32, 32, 32, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 32, 32, 32, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 33, 11, 11, 11, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 11, 11, 11, 33, 4, 4, 4, 4, 4, 4, 4, 4, 32, 32, 32, 4, 33, 33, 33, 33, 33, 33, 33, 33, 33, 1, 1, 1, 33, 33, 33, 33, 33, 33, 33, 33, 33, 4, 33, 33, 33, 4, 4, 4, 4, 32, 32, 32, 25, 33, 33, 11, 33, 33, 33, 33, 33, 33, 1, 7, 1, 33, 33, 33, 33, 33, 33, 11, 33, 33, 31, 33, 11, 33, 4, 4, 4, 4, 32, 32, 32, 4, 33, 33, 33, 33, 33, 33, 33, 33, 33, 1, 1, 1, 33, 33, 33, 33, 33, 33, 33, 33, 33, 4, 33, 33, 33, 4, 4, 4, 4, 4, 25, 4, 4, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 4, 4, 33, 4, 4, 4, 4, 4, 4, 25, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 33, 4, 4, 4, 4, 32, 32, 32, 32, 32, 4, 4, 32, 32, 32, 32, 32, 4, 4, 32, 32, 32, 32, 32, 4, 4, 32, 32, 32, 32, 32, 4, 33, 33, 33, 4, 4, 4, 32, 32, 34, 32, 32, 25, 25, 32, 32, 34, 32, 32, 25, 25, 32, 32, 34, 32, 32, 25, 25, 32, 32, 34, 32, 32, 25, 33, 11, 33, 4, 4, 4, 32, 32, 32, 32, 32, 4, 4, 32, 32, 32, 32, 32, 4, 4, 32, 32, 32, 32, 32, 4, 4, 32, 32, 32, 32, 32, 4, 33, 33, 33, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 32, 32, 32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final String ISCOMPLETED = "iscompleted";

    public LabsBossLevel() {
        this.color1 = 4748860;
        this.color2 = 5871946;
    }

    @Override
    public void playLevelMusic() {
        Music.INSTANCE.playTracks(new String[]{"music/halls_1.ogg", "music/halls_2.ogg", "music/halls_2.ogg"}, new float[]{1.0f, 1.0f, 0.5f}, false);
    }

    @Override
    public String tilesTex() {
        return "environment/tiles_labs.png";
    }

    @Override
    public String waterTex() {
        return "environment/water5.png";
    }

    @Override
    protected boolean build() {
        this.setSize(WIDTH, HEIGHT);
        this.transitions.add(new LevelTransition(this, 1006, LevelTransition.Type.REGULAR_ENTRANCE));
        int exitCell = 49;
        LevelTransition exit = new LevelTransition(this, exitCell, LevelTransition.Type.REGULAR_EXIT);
        exit.set(exitDoor);
        this.transitions.add(exit);
        this.buildLevel();
        return true;
    }

    private void buildLevel() {
        int pos = 0 + 0 * this.width();
        short[] levelTiles = level;
        for (int i = 0; i < levelTiles.length; ++i) {
            if (levelTiles[i] != -1) {
                this.map[pos] = levelTiles[i];
            }
            ++pos;
        }
        Blob.seed(1191, 12, ConfusionGasSeed.class, this);
        Blob.seed(1198, 12, ToxicGasSeed.class, this);
        Blob.seed(1205, 12, ParalyticGasSeed.class, this);
        Blob.seed(1212, 12, CorrosiveGasSeed.class, this);
    }

    @Override
    public void occupyCell(Char ch) {
        super.occupyCell(ch);
        boolean isRebelAlive = false;
        for (int i = 0; i < Dungeon.level.length; ++i) {
            Char mob = Actor.findChar(i);
            if (!(mob instanceof Rebel)) continue;
            isRebelAlive = true;
            break;
        }
        if (this.map[bottomDoor] != 10 && ch.pos < bottomDoor && ch == Dungeon.hero && !isCompleted) {
            this.seal();
            return;
        }
        if (Dungeon.level.map[49] == 21 && ch.pos < bottomDoor && ch == Dungeon.hero && !isRebelAlive) {
            this.seal();
        }
    }

    @Override
    protected void createMobs() {
    }

    @Override
    protected void createItems() {
        Item prize1 = Random.oneOf(new Gold(3000), new PotionOfHealing().quantity(3), new StoneOfEnchantment().quantity(3), Generator.randomArtifact(), Generator.randomWeapon(5).upgrade(3), Generator.randomArmor(5).upgrade(3), new PotionOfArmorEnhance().quantity(5), new PotionOfWeaponEnhance().quantity(5));
        Item prize2 = Random.oneOf(new Gold(3000), new PotionOfHealing().quantity(3), new StoneOfEnchantment().quantity(3), Generator.randomArtifact(), Generator.randomWeapon(5).upgrade(3), Generator.randomArmor(5).upgrade(3), new PotionOfArmorEnhance().quantity(5), new PotionOfWeaponEnhance().quantity(5));
        Item prize3 = Random.oneOf(new Gold(3000), new PotionOfHealing().quantity(3), new StoneOfEnchantment().quantity(3), Generator.randomArtifact(), Generator.randomWeapon(5).upgrade(3), Generator.randomArmor(5).upgrade(3), new PotionOfArmorEnhance().quantity(5), new PotionOfWeaponEnhance().quantity(5));
        Item prize4 = Random.oneOf(new Gold(3000), new PotionOfHealing().quantity(3), new StoneOfEnchantment().quantity(3), Generator.randomArtifact(), Generator.randomWeapon(5).upgrade(3), Generator.randomArmor(5).upgrade(3), new PotionOfArmorEnhance().quantity(5), new PotionOfWeaponEnhance().quantity(5));
        Item prize5 = Random.oneOf(new Gold(3000), new PotionOfHealing().quantity(3), new StoneOfEnchantment().quantity(3), Generator.randomArtifact(), Generator.randomWeapon(5).upgrade(3), Generator.randomArmor(5).upgrade(3), new PotionOfArmorEnhance().quantity(5), new PotionOfWeaponEnhance().quantity(5));
        Item prize6 = Random.oneOf(new Gold(3000), new PotionOfHealing().quantity(3), new StoneOfEnchantment().quantity(3), Generator.randomArtifact(), Generator.randomWeapon(5).upgrade(3), Generator.randomArmor(5).upgrade(3), new PotionOfArmorEnhance().quantity(5), new PotionOfWeaponEnhance().quantity(5));
        this.drop(new HandyBarricade().quantity(5), 998);
        this.drop(new HandyBarricade().quantity(5), 1014);
        this.drop((Item)new CrystalKey((int)30), (int)1019).type = Heap.Type.CHEST;
        this.drop((Item)new GoldenKey((int)30).quantity((int)Random.NormalIntRange((int)1, (int)6)), (int)1217).type = Heap.Type.CHEST;
        this.drop((Item)prize1, (int)931).type = Heap.Type.LOCKED_CHEST;
        this.drop((Item)prize2, (int)932).type = Heap.Type.LOCKED_CHEST;
        this.drop((Item)prize3, (int)933).type = Heap.Type.LOCKED_CHEST;
        this.drop((Item)prize4, (int)947).type = Heap.Type.LOCKED_CHEST;
        this.drop((Item)prize5, (int)948).type = Heap.Type.LOCKED_CHEST;
        this.drop((Item)prize6, (int)949).type = Heap.Type.LOCKED_CHEST;
        Item item = Bones.get();
        if (item != null) {
            int pos;
            while ((pos = this.randomRespawnCell(null)) == this.entrance()) {
            }
            this.drop((Item)item, (int)pos).setHauntedIfCursed().type = Heap.Type.REMAINS;
        }
    }

    public int randomCellPos() {
        int eC_1 = Random.IntRange(238, 256);
        int eC_2 = Random.IntRange(271, 289);
        int eC_3 = Random.IntRange(304, 322);
        int eC_4 = Random.IntRange(337, 355);
        int eC_5 = Random.IntRange(370, 388);
        int eC_6 = Random.IntRange(403, 421);
        int eC_7 = Random.IntRange(436, 454);
        int eC_8 = Random.IntRange(469, 487);
        int eC_9 = Random.IntRange(502, 520);
        int eC_10 = Random.IntRange(535, 553);
        int eC_11 = Random.IntRange(568, 586);
        int eC_12 = Random.IntRange(601, 619);
        int eC_13 = Random.IntRange(634, 652);
        int eC_14 = Random.IntRange(667, 685);
        int eC_15 = Random.IntRange(700, 718);
        int eC_16 = Random.IntRange(733, 751);
        int eC_17 = Random.IntRange(766, 784);
        int eC_18 = Random.IntRange(799, 817);
        int eC_19 = Random.IntRange(832, 850);
        int randomEmptyCell = Random.oneOf(eC_1, eC_2, eC_3, eC_4, eC_5, eC_6, eC_7, eC_8, eC_9, eC_10, eC_11, eC_12, eC_13, eC_14, eC_15, eC_16, eC_17, eC_18, eC_19);
        return randomEmptyCell;
    }

    @Override
    public int randomRespawnCell(Char ch) {
        int cell;
        while (!this.passable[cell = this.entrance() + PathFinder.NEIGHBOURS8[Random.Int(8)]] || Char.hasProp(ch, Char.Property.LARGE) && !this.openSpace[cell] || Actor.findChar(cell) != null) {
        }
        return cell;
    }

    @Override
    public void seal() {
        super.seal();
        Rebel boss = new Rebel();
        boss.state = boss.WANDERING;
        boss.pos = bottomDoor - 363;
        GameScene.add(boss);
        boss.beckon(Dungeon.hero.pos);
        if (this.heroFOV[boss.pos]) {
            boss.notice();
            boss.sprite.alpha(0.0f);
            boss.sprite.parent.add(new AlphaTweener(boss.sprite, 1.0f, 0.1f));
        }
        int doorPos = bottomDoor;
        Mob.holdAllies(this, doorPos);
        Mob.restoreAllies(this, Dungeon.hero.pos, doorPos);
        LabsBossLevel.set(bottomDoor, 10);
        GameScene.updateMap(bottomDoor);
        Dungeon.observe();
    }

    @Override
    public void unseal() {
        super.unseal();
        LabsBossLevel.set(49, 22);
        LabsBossLevel.set(bottomDoor, 5);
        GameScene.updateMap(49);
        CellEmitter.get(49).burst(Speck.factory(7), 8);
        GameScene.updateMap(bottomDoor);
        isCompleted = true;
        Dungeon.observe();
    }

    @Override
    public String tileName(int tile) {
        switch (tile) {
            case 29: {
                return Messages.get(LabsLevel.class, "water_name", new Object[0]);
            }
            case 12: {
                return Messages.get(LabsLevel.class, "wall_deco_name", new Object[0]);
            }
            case 25: {
                return Messages.get(LabsLevel.class, "statue_name", new Object[0]);
            }
            case 32: {
                return Messages.get(LabsLevel.class, "custom_tile_1_name", new Object[0]);
            }
            case 33: {
                return Messages.get(LabsLevel.class, "custom_tile_2_name", new Object[0]);
            }
            case 34: {
                return Messages.get(LabsLevel.class, "custom_tile_3_name", new Object[0]);
            }
            case 21: {
                return Messages.get(LabsLevel.class, "locked_exit_name", new Object[0]);
            }
            case 22: {
                return Messages.get(LabsLevel.class, "unlocked_exit_name", new Object[0]);
            }
        }
        return super.tileName(tile);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(ISCOMPLETED, isCompleted);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        isCompleted = bundle.getBoolean(ISCOMPLETED);
        if (bundle.contains("exit")) {
            LevelTransition exit = this.getTransition(LevelTransition.Type.REGULAR_EXIT);
            exit.set(16, 1, 16, 1);
            this.transitions.add(exit);
        }
    }

    @Override
    public String tileDesc(int tile) {
        switch (tile) {
            case 7: {
                return Messages.get(LabsLevel.class, "entrance_desc", new Object[0]);
            }
            case 8: {
                return Messages.get(LabsLevel.class, "exit_desc", new Object[0]);
            }
            case 20: {
                return Messages.get(LabsLevel.class, "empty_deco_desc", new Object[0]);
            }
            case 12: {
                return Messages.get(LabsLevel.class, "wall_deco_desc", new Object[0]);
            }
            case 27: {
                return Messages.get(LabsLevel.class, "bookshelf_desc", new Object[0]);
            }
            case 25: {
                return Messages.get(LabsLevel.class, "statue_desc", new Object[0]);
            }
            case 32: {
                return Messages.get(LabsLevel.class, "custom_tile_1_desc", new Object[0]);
            }
            case 33: {
                return Messages.get(LabsLevel.class, "custom_tile_2_desc", new Object[0]);
            }
            case 34: {
                return Messages.get(LabsLevel.class, "custom_tile_3_desc", new Object[0]);
            }
            case 21: {
                return Messages.get(LabsLevel.class, "locked_exit_desc", new Object[0]);
            }
            case 22: {
                return Messages.get(LabsLevel.class, "unlocked_exit_desc", new Object[0]);
            }
        }
        return super.tileDesc(tile);
    }

    public static class ConfusionGasSeed
    extends Blob {
        @Override
        protected void evolve() {
            ConfusionGas gas = (ConfusionGas)Dungeon.level.blobs.get(ConfusionGas.class);
            for (int i = this.area.top - 1; i <= this.area.bottom; ++i) {
                for (int j = this.area.left - 1; j <= this.area.right; ++j) {
                    int cell = j + i * Dungeon.level.width();
                    if (!Dungeon.level.insideMap(cell)) continue;
                    this.off[cell] = this.cur[cell];
                    this.volume += this.off[cell];
                    if (gas == null || gas.volume == 0) {
                        GameScene.add(Blob.seed(cell, 300, ConfusionGas.class));
                        continue;
                    }
                    if (gas.cur[cell] > 9 * this.off[cell]) continue;
                    GameScene.add(Blob.seed(cell, 300, ConfusionGas.class));
                }
            }
        }
    }

    public static class ToxicGasSeed
    extends Blob {
        @Override
        protected void evolve() {
            ToxicGas gas = (ToxicGas)Dungeon.level.blobs.get(ToxicGas.class);
            for (int i = this.area.top - 1; i <= this.area.bottom; ++i) {
                for (int j = this.area.left - 1; j <= this.area.right; ++j) {
                    int cell = j + i * Dungeon.level.width();
                    if (!Dungeon.level.insideMap(cell)) continue;
                    this.off[cell] = this.cur[cell];
                    this.volume += this.off[cell];
                    if (gas == null || gas.volume == 0) {
                        GameScene.add(Blob.seed(cell, 300, ToxicGas.class));
                        continue;
                    }
                    if (gas.cur[cell] > 9 * this.off[cell]) continue;
                    GameScene.add(Blob.seed(cell, 300, ToxicGas.class));
                }
            }
        }
    }

    public static class ParalyticGasSeed
    extends Blob {
        @Override
        protected void evolve() {
            ParalyticGas gas = (ParalyticGas)Dungeon.level.blobs.get(ParalyticGas.class);
            for (int i = this.area.top - 1; i <= this.area.bottom; ++i) {
                for (int j = this.area.left - 1; j <= this.area.right; ++j) {
                    int cell = j + i * Dungeon.level.width();
                    if (!Dungeon.level.insideMap(cell)) continue;
                    this.off[cell] = this.cur[cell];
                    this.volume += this.off[cell];
                    if (gas == null || gas.volume == 0) {
                        GameScene.add(Blob.seed(cell, 300, ParalyticGas.class));
                        continue;
                    }
                    if (gas.cur[cell] > 9 * this.off[cell]) continue;
                    GameScene.add(Blob.seed(cell, 300, ParalyticGas.class));
                }
            }
        }
    }

    public static class CorrosiveGasSeed
    extends Blob {
        @Override
        protected void evolve() {
            CorrosiveGas gas = (CorrosiveGas)Dungeon.level.blobs.get(CorrosiveGas.class);
            for (int i = this.area.top - 1; i <= this.area.bottom; ++i) {
                for (int j = this.area.left - 1; j <= this.area.right; ++j) {
                    int cell = j + i * Dungeon.level.width();
                    if (!Dungeon.level.insideMap(cell)) continue;
                    this.off[cell] = this.cur[cell];
                    this.volume += this.off[cell];
                    if (gas == null || gas.volume == 0) {
                        GameScene.add(Blob.seed(cell, 300, CorrosiveGas.class));
                        continue;
                    }
                    if (gas.cur[cell] > 9 * this.off[cell]) continue;
                    GameScene.add(Blob.seed(cell, 300, CorrosiveGas.class));
                }
            }
        }
    }
}

