/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.journal;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.Key;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import java.util.ArrayList;
import java.util.Collections;

public class Notes {
    private static ArrayList<Record> records;
    private static final String RECORDS = "records";

    public static void reset() {
        records = new ArrayList();
    }

    public static void storeInBundle(Bundle bundle) {
        bundle.put(RECORDS, records);
    }

    public static void restoreFromBundle(Bundle bundle) {
        records = new ArrayList();
        for (Bundlable rec : bundle.getCollection(RECORDS)) {
            records.add((Record)rec);
        }
    }

    public static boolean add(Landmark landmark) {
        LandmarkRecord l = new LandmarkRecord(landmark, Dungeon.depth);
        if (!records.contains(l)) {
            boolean result = records.add(new LandmarkRecord(landmark, Dungeon.depth));
            Collections.sort(records);
            return result;
        }
        return false;
    }

    public static boolean remove(Landmark landmark) {
        return records.remove(new LandmarkRecord(landmark, Dungeon.depth));
    }

    public static boolean add(Key key) {
        KeyRecord k = new KeyRecord(key);
        if (!records.contains(k)) {
            boolean result = records.add(k);
            Collections.sort(records);
            return result;
        }
        k = (KeyRecord)records.get(records.indexOf(k));
        k.quantity(k.quantity() + key.quantity());
        return true;
    }

    public static boolean remove(Key key) {
        KeyRecord k = new KeyRecord(key);
        if (records.contains(k)) {
            k = (KeyRecord)records.get(records.indexOf(k));
            k.quantity(k.quantity() - key.quantity());
            if (k.quantity() <= 0) {
                records.remove(k);
            }
            return true;
        }
        return false;
    }

    public static int keyCount(Key key) {
        KeyRecord k = new KeyRecord(key);
        if (records.contains(k)) {
            k = (KeyRecord)records.get(records.indexOf(k));
            return k.quantity();
        }
        return 0;
    }

    public static ArrayList<Record> getRecords() {
        return Notes.getRecords(Record.class);
    }

    public static <T extends Record> ArrayList<T> getRecords(Class<T> recordType) {
        ArrayList<Record> filtered = new ArrayList<Record>();
        for (Record rec : records) {
            if (!recordType.isInstance(rec)) continue;
            filtered.add(rec);
        }
        return filtered;
    }

    public static void remove(Record rec) {
        records.remove(rec);
    }

    public static abstract class Record
    implements Comparable<Record>,
    Bundlable {
        protected int depth;
        private static final String DEPTH = "depth";

        public int depth() {
            return this.depth;
        }

        public abstract String desc();

        public abstract boolean equals(Object var1);

        @Override
        public int compareTo(Record another) {
            return another.depth() - this.depth();
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            this.depth = bundle.getInt(DEPTH);
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            bundle.put(DEPTH, this.depth);
        }
    }

    public static class LandmarkRecord
    extends Record {
        protected Landmark landmark;
        private static final String LANDMARK = "landmark";

        public LandmarkRecord() {
        }

        public LandmarkRecord(Landmark landmark, int depth) {
            this.landmark = landmark;
            this.depth = depth;
        }

        @Override
        public String desc() {
            return this.landmark.desc();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LandmarkRecord && this.landmark == ((LandmarkRecord)obj).landmark && this.depth() == ((LandmarkRecord)obj).depth();
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.landmark = Landmark.valueOf(bundle.getString(LANDMARK));
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(LANDMARK, this.landmark.name());
        }
    }

    public static enum Landmark {
        WELL_OF_HEALTH,
        WELL_OF_AWARENESS,
        ALCHEMY,
        GARDEN,
        STATUE,
        SACRIFICIAL_FIRE,
        SHOP,
        GHOST,
        WANDMAKER,
        TROLL,
        IMP,
        DEMON_SPAWNER;


        public String desc() {
            return Messages.get((Object)this, this.name(), new Object[0]);
        }
    }

    public static class KeyRecord
    extends Record {
        protected Key key;
        private static final String KEY = "key";

        public KeyRecord() {
        }

        public KeyRecord(Key key) {
            this.key = key;
        }

        @Override
        public int depth() {
            return this.key.depth;
        }

        @Override
        public String desc() {
            return this.key.title();
        }

        public Class<? extends Key> type() {
            return this.key.getClass();
        }

        public int quantity() {
            return this.key.quantity();
        }

        public void quantity(int num) {
            this.key.quantity(num);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof KeyRecord && this.key.isSimilar(((KeyRecord)obj).key);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.key = (Key)bundle.get(KEY);
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(KEY, this.key);
        }
    }
}

