/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Piranha;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Ballista;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class FishingSpear
extends MissileWeapon {
    private static Ballista bow;
    private boolean processingChargedShot;
    private int chargedShotPos;

    public FishingSpear() {
        this.image = ItemSpriteSheet.FISHING_SPEAR;
        this.hitSound = "sounds/hit_stab.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 2;
        this.processingChargedShot = false;
    }

    @Override
    public int min(int lvl) {
        if (bow != null) {
            return 4 * this.tier + bow.buffedLvl() + 2 * lvl;
        }
        return 2 * this.tier + 2 * lvl;
    }

    @Override
    public int max(int lvl) {
        if (bow != null) {
            return 7 * this.tier + bow.buffedLvl() * (this.tier + 1) + this.tier * lvl;
        }
        return 5 * this.tier + this.tier * lvl;
    }

    private void updateBallista() {
        bow = Dungeon.hero.belongings.weapon() instanceof Ballista ? (Ballista)Dungeon.hero.belongings.weapon() : (Dungeon.hero.belongings.secondWep() instanceof Ballista ? (Ballista)Dungeon.hero.belongings.secondWep() : null);
    }

    public boolean ballistaHasEnchant(Char owner) {
        return bow != null && FishingSpear.bow.enchantment != null && owner.buff(MagicImmune.class) == null;
    }

    @Override
    public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
        if (bow != null && bow.hasEnchant(type, owner)) {
            return true;
        }
        return super.hasEnchant(type, owner);
    }

    @Override
    public int throwPos(Hero user, int dst) {
        this.updateBallista();
        return super.throwPos(user, dst);
    }

    @Override
    protected void onThrow(int cell) {
        this.updateBallista();
        this.chargedShotPos = cell;
        super.onThrow(cell);
    }

    @Override
    public void throwSound() {
        this.updateBallista();
        if (bow != null) {
            Sample.INSTANCE.play("sounds/atk_crossbow.mp3", 1.0f, Random.Float(0.87f, 1.15f));
        } else {
            super.throwSound();
        }
    }

    @Override
    public String info() {
        this.updateBallista();
        if (bow != null && !bow.isIdentified()) {
            int level = bow.level();
            bow.level(0);
            String info = super.info();
            bow.level(level);
            return info;
        }
        return super.info();
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (bow != null) {
            damage = bow.proc(attacker, defender, damage);
        }
        if (defender instanceof Piranha) {
            damage = Math.max(damage, defender.HP / 2);
        }
        if (!this.processingChargedShot) {
            this.processChargedShot(defender, damage);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public float accuracyFactor(Char owner, Char target) {
        if (bow != null && owner.buff(Ballista.BallistaShot.class) != null) {
            return Char.INFINITE_ACCURACY;
        }
        return super.accuracyFactor(owner, target);
    }

    protected void processChargedShot(Char target, int dmg) {
        this.processingChargedShot = true;
        if (this.chargedShotPos != -1 && bow != null && Dungeon.hero.buff(Ballista.BallistaShot.class) != null) {
            PathFinder.buildDistanceMap(this.chargedShotPos, Dungeon.level.passable, 1);
            for (int i : PathFinder.NEIGHBOURS9) {
                int c = this.chargedShotPos + i;
                if (c < 0 || c >= Dungeon.level.length()) continue;
                if (Dungeon.level.heroFOV[c]) {
                    CellEmitter.get(c).burst(SmokeParticle.FACTORY, 4);
                    CellEmitter.center(this.chargedShotPos).burst(BlastParticle.FACTORY, 4);
                }
                if (!Dungeon.level.flamable[c]) continue;
                Dungeon.level.destroy(c);
                GameScene.updateMap(c);
            }
            int[] distance = (int[])PathFinder.distance.clone();
            for (final Char ch : Actor.chars()) {
                if (ch == target) {
                    Actor.add(new Actor(){
                        {
                            this.actPriority = 100;
                        }

                        @Override
                        protected boolean act() {
                            if (!ch.isAlive()) {
                                bow;
                                Ballista.onAbilityKill(Dungeon.hero, ch);
                            }
                            Actor.remove(this);
                            return true;
                        }
                    });
                } else if (distance[ch.pos] != Integer.MAX_VALUE) {
                    this.proc(Dungeon.hero, ch, dmg);
                }
                if (ch == target || distance[ch.pos] == Integer.MAX_VALUE) continue;
                int damage = this.damageRoll(Dungeon.hero);
                ch.damage(damage -= ch.drRoll(), Dungeon.hero);
            }
            Sample.INSTANCE.play("sounds/blast.mp3");
        }
        this.chargedShotPos = -1;
        this.processingChargedShot = false;
    }

    @Override
    protected void decrementDurability() {
        super.decrementDurability();
        if (Dungeon.hero.buff(Ballista.BallistaShot.class) != null) {
            Dungeon.hero.buff(Ballista.BallistaShot.class).detach();
        }
    }
}

