/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Charm;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfSirensSong;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfTransfusion;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class SpellBook_Transfusion
extends SpellBook {
    public SpellBook_Transfusion() {
        this.image = ItemSpriteSheet.TRANSFUSION_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        float missingPercent = (float)(attacker.HT - attacker.HP) / (float)attacker.HT;
        float procChance = 0.05f + (0.25f + 0.01f * (float)this.buffedLvl()) * missingPercent;
        if (Random.Float() < procChance) {
            int healAmt = Math.round((float)damage * 0.4f);
            attacker.heal(healAmt);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        needAnimation = busy;
        int[] pathFinder = this.buffedLvl() >= 10 ? PathFinder.NEIGHBOURS25 : PathFinder.NEIGHBOURS9;
        for (int i : pathFinder) {
            int c = hero.pos + i;
            Mob target = null;
            Char ch = Actor.findChar(c);
            if (ch != null && ch.alignment != Char.Alignment.ALLY && ch instanceof Mob) {
                target = (Mob)ch;
            }
            if (target != null) {
                if (this.buffedLvl() >= 10 && Random.Int(50) < this.buffedLvl() && !target.isImmune(ScrollOfSirensSong.Enthralled.class)) {
                    AllyBuff.affectAndLoot(target, curUser, ScrollOfSirensSong.Enthralled.class);
                } else {
                    Buff.affect((Char)target, Charm.class, (float)(10.0f + (float)(2 * this.buffedLvl()))).object = curUser.id();
                }
                target.sprite.centerEmitter().burst(Speck.factory(11), 10);
            }
            CellEmitter.get(c).burst(Speck.factory(11), 1);
        }
        Sample.INSTANCE.play("sounds/charms.mp3");
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfTransfusion.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Transfusion.class;
            this.outQuantity = 1;
        }
    }
}

