/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blizzard;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Freezing;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Chill;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FrostImbue;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Splash;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfFrost;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class SpellBook_Frost
extends SpellBook {
    public SpellBook_Frost() {
        this.image = ItemSpriteSheet.FROST_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        float procChance = ((float)this.buffedLvl() + 1.0f) / ((float)this.buffedLvl() + 4.0f);
        if (Random.Float() < procChance) {
            float durationToAdd = 3.0f;
            Chill existing = defender.buff(Chill.class);
            if (existing != null) {
                durationToAdd = Math.min(durationToAdd, 6.0f - existing.cooldown());
            }
            Buff.affect(defender, Chill.class, durationToAdd);
            Splash.at(defender.sprite.center(), -5056769, 5);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        needAnimation = busy;
        int[] pathFinder = this.buffedLvl() >= 10 ? PathFinder.NEIGHBOURS25 : PathFinder.NEIGHBOURS9;
        for (int i : pathFinder) {
            int c = hero.pos + i;
            if (Dungeon.level.map[c] == 4 || !Dungeon.level.heroFOV[c]) continue;
            if (Dungeon.level.pit[c]) {
                GameScene.add(Blob.seed(c, 2, Freezing.class));
            } else {
                if (Dungeon.level.water[c]) {
                    GameScene.add(Blob.seed(c, 20 + this.buffedLvl(), Freezing.class));
                } else {
                    GameScene.add(Blob.seed(c, 5 + this.buffedLvl(), Freezing.class));
                }
                if (this.buffedLvl() >= 10) {
                    GameScene.add(Blob.seed(c, 50 + 10 * this.buffedLvl(), Blizzard.class));
                }
            }
            Splash.at(c, -5056769, 5);
        }
        Sample.INSTANCE.play("sounds/shatter.mp3");
        Buff.affect(hero, FrostImbue.class, Math.min(10 + 2 * this.buffedLvl(), 50));
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfFrost.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Frost.class;
            this.outQuantity = 1;
        }
    }
}

