/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Fire;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Inferno;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FireImbue;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.FlameParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfFireblast;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class SpellBook_Fire
extends SpellBook {
    public SpellBook_Fire() {
        this.image = ItemSpriteSheet.FIRE_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        float procChance = ((float)this.buffedLvl() + 1.0f) / ((float)this.buffedLvl() + 3.0f);
        if (Random.Float() < procChance) {
            if (defender.buff(Burning.class) != null) {
                Buff.affect(defender, Burning.class).reignite(defender, 8.0f);
                int burnDamage = Random.NormalIntRange(1, 3 + Dungeon.depth / 4);
                defender.damage(Math.round((float)burnDamage * 0.67f), this);
            } else {
                Buff.affect(defender, Burning.class).reignite(defender, 8.0f);
            }
            defender.sprite.emitter().burst(FlameParticle.FACTORY, this.buffedLvl() + 1);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        needAnimation = busy;
        int[] pathFinder = this.buffedLvl() >= 10 ? PathFinder.NEIGHBOURS25 : PathFinder.NEIGHBOURS9;
        for (int i : pathFinder) {
            int c = hero.pos + i;
            if (Dungeon.level.map[c] == 4 || !Dungeon.level.heroFOV[c]) continue;
            if (Dungeon.level.pit[c]) {
                GameScene.add(Blob.seed(c, 1, Fire.class));
                continue;
            }
            if (this.buffedLvl() >= 10) {
                GameScene.add(Blob.seed(c, 50 + 20 * this.buffedLvl(), Inferno.class));
                continue;
            }
            GameScene.add(Blob.seed(c, 5, Fire.class));
        }
        Sample.INSTANCE.play("sounds/burning.mp3");
        Buff.affect(hero, FireImbue.class).set(Math.min(10 + 3 * this.buffedLvl(), 80));
        hero.sprite.emitter().burst(FlameParticle.FACTORY, this.buffedLvl() + 3);
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfFireblast.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Fire.class;
            this.outQuantity = 1;
        }
    }
}

