/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArcaneArmor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArtifactRecharge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Awareness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barkskin;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.EvasiveMove;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.effects.Enchanting;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.Transmuting;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.EnergyParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfMagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class SpellBook_Empty
extends SpellBook {
    public static final String AC_INFUSE = "INFUSE";
    public static final String AC_TRANSMUTE = "TRANSMUTE";

    public SpellBook_Empty() {
        this.image = ItemSpriteSheet.EMPTY_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (Dungeon.hero.subClass == HeroSubClass.WIZARD) {
            actions.add(AC_INFUSE);
            actions.add(AC_TRANSMUTE);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_INFUSE)) {
            if (this.enchantment != null) {
                GLog.w(Messages.get(this, "already_infused", new Object[0]), new Object[0]);
                return;
            }
            this.enchant();
            GLog.p(Messages.get(this, "infuse", new Object[0]), new Object[0]);
            SpellBook_Empty.curUser.sprite.emitter().start(Speck.factory(2), 0.1f, 5);
            Enchanting.show(curUser, this);
            curUser.spend(1.0f);
            curUser.busy();
            SpellBook_Empty.curUser.sprite.operate(SpellBook_Empty.curUser.pos);
            Sample.INSTANCE.play("sounds/read.mp3");
            Invisibility.dispel();
        }
        if (action.equals(AC_TRANSMUTE)) {
            Item result = SpellBook_Empty.changeWeapon(this);
            if (result != this) {
                int slot = Dungeon.quickslot.getSlot(this);
                if (this.isEquipped(Dungeon.hero)) {
                    this.cursed = false;
                    if (Dungeon.hero.belongings.secondWep() == this) {
                        this.doUnequip(Dungeon.hero, false);
                        ((KindOfWeapon)result).equipSecondary(Dungeon.hero);
                    } else {
                        this.doUnequip(Dungeon.hero, false);
                        ((EquipableItem)result).doEquip(Dungeon.hero);
                    }
                    Dungeon.hero.spend(-Dungeon.hero.cooldown());
                } else {
                    this.detach(Dungeon.hero.belongings.backpack);
                    if (!result.collect()) {
                        Dungeon.level.drop((Item)result, (int)SpellBook_Empty.curUser.pos).sprite.drop();
                    } else if (Dungeon.hero.belongings.getSimilar(result) != null) {
                        result = Dungeon.hero.belongings.getSimilar(result);
                    }
                }
                if (slot != -1 && result.defaultAction() != null && !Dungeon.quickslot.isNonePlaceholder(slot).booleanValue() && Dungeon.hero.belongings.contains(result)) {
                    Dungeon.quickslot.setSlot(slot, result);
                }
            }
            if (result.isIdentified()) {
                Catalog.setSeen(result.getClass());
            }
            Transmuting.show((Char)curUser, this, result);
            SpellBook_Empty.curUser.sprite.emitter().start(Speck.factory(10), 0.2f, 10);
            GLog.p(Messages.get(this, "transmute", new Object[0]), new Object[0]);
        }
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        needAnimation = busy;
        switch (Random.Int(10)) {
            default: {
                Buff.affect(hero, Recharging.class, 20.0f + (float)this.buffedLvl());
                GLog.p(Messages.get(this, "recharge", new Object[0]), new Object[0]);
                break;
            }
            case 1: {
                Buff.affect(hero, ArtifactRecharge.class).set(10.0f + (float)this.buffedLvl());
                GLog.p(Messages.get(this, "artifact", new Object[0]), new Object[0]);
                break;
            }
            case 2: {
                Buff.affect(hero, Bless.class, 20.0f + (float)this.buffedLvl());
                GLog.p(Messages.get(this, "bless", new Object[0]), new Object[0]);
                break;
            }
            case 3: {
                Buff.affect(hero, Adrenaline.class, 10.0f + (float)this.buffedLvl());
                GLog.p(Messages.get(this, "adrenaline", new Object[0]), new Object[0]);
                break;
            }
            case 4: {
                Buff.affect(hero, Barrier.class).setShield(Dungeon.depth + this.buffedLvl() + 5);
                GLog.p(Messages.get(this, "barrier", new Object[0]), new Object[0]);
                break;
            }
            case 5: {
                Buff.affect(hero, Barkskin.class).set(Dungeon.depth / 2 + this.buffedLvl() + 5, 1);
                GLog.p(Messages.get(this, "barkskin", new Object[0]), new Object[0]);
                break;
            }
            case 6: {
                Buff.affect(hero, Invisibility.class, 10.0f + (float)this.buffedLvl());
                GLog.p(Messages.get(this, "invisibility", new Object[0]), new Object[0]);
                break;
            }
            case 7: {
                Buff.affect(hero, ArcaneArmor.class).set(Dungeon.depth / 2 + this.buffedLvl() + 5, 1);
                GLog.p(Messages.get(this, "arcane_armor", new Object[0]), new Object[0]);
                break;
            }
            case 8: {
                Buff.affect(hero, Awareness.class, 2.0f);
                GLog.p(Messages.get(this, "awareness", new Object[0]), new Object[0]);
                break;
            }
            case 9: {
                Buff.affect(hero, EvasiveMove.class, 3.0f);
                GLog.p(Messages.get(this, "evasive_move", new Object[0]), new Object[0]);
            }
        }
        Sample.INSTANCE.play("sounds/chargeup.mp3");
        Emitter e = hero.sprite.centerEmitter();
        if (e != null) {
            e.burst(EnergyParticle.FACTORY, 15);
        }
        if (needAnimation) {
            this.readAnimation();
        }
    }

    private static Weapon changeWeapon(Weapon w) {
        Weapon n = (Weapon)Generator.randomUsingDefaults(Generator.Category.SPELLBOOK);
        n.level(0);
        n.quantity(1);
        int level = w.trueLevel();
        if (level > 0) {
            n.upgrade(level);
        } else if (level < 0) {
            n.degrade(-level);
        }
        n.enchantment = w.enchantment;
        n.curseInfusionBonus = w.curseInfusionBonus;
        n.masteryPotionBonus = w.masteryPotionBonus;
        n.levelKnown = w.levelKnown;
        n.cursedKnown = w.cursedKnown;
        n.cursed = w.cursed;
        n.augment = w.augment;
        n.isUpgraded = w.isUpgraded;
        return n;
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{WandOfMagicMissile.class};
            this.inQuantity = new int[]{1};
            this.cost = 5;
            this.output = SpellBook_Empty.class;
            this.outQuantity = 1;
        }
    }
}

