/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicalSight;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TalismanOfForesight;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfDisintegration;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Bundle;
import java.util.ArrayList;

public class SpellBook_Disintegration
extends SpellBook {
    public SpellBook_Disintegration() {
        this.image = ItemSpriteSheet.DISTRIBUTION_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        Buff.affect(defender, VisionBuff.class, 3 + this.buffedLvl());
        Buff.append((Char)Dungeon.hero, TalismanOfForesight.CharAwareness.class, (float)((float)(3 + this.buffedLvl()))).charID = defender.id();
        return super.proc(attacker, defender, damage);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        needAnimation = busy;
        Buff.affect(hero, ReachBuff.class).set(4 + this.buffedLvl(), this.buffedLvl());
        if (this.buffedLvl() >= 10) {
            Buff.affect(hero, MagicalSight.class, 10.0f);
        }
        Sample.INSTANCE.play("sounds/chargeup.mp3");
        Emitter e = hero.sprite.centerEmitter();
        if (e != null) {
            e.burst(ShadowParticle.CURSE, 15);
        }
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public static class VisionBuff
    extends FlavourBuff {
    }

    public static class ReachBuff
    extends Buff {
        private int maxDuration;
        private int left;
        private int upgrade;
        private static final String MAX_DURATION = "maxDuration";
        private static final String LEFT = "left";
        private static final String UPGRADE = "upgrade";

        @Override
        public int icon() {
            return 45;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(5898418);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0, (this.maxDuration - this.left) / this.maxDuration);
        }

        public void set(int duration, int lvl) {
            this.left = this.maxDuration = duration;
            this.upgrade = lvl;
            if (this.upgrade > 9) {
                this.upgrade = 9;
            }
        }

        public int getUpgrade() {
            return this.upgrade;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(MAX_DURATION, this.maxDuration);
            bundle.put(LEFT, this.left);
            bundle.put(UPGRADE, this.upgrade);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.maxDuration = bundle.getInt(MAX_DURATION);
            this.left = bundle.getInt(LEFT);
            this.upgrade = bundle.getInt(UPGRADE);
        }

        @Override
        public String iconTextDisplay() {
            return Integer.toString(this.left);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", 1 + this.upgrade, this.left);
        }

        @Override
        public boolean act() {
            --this.left;
            if (this.left <= 0) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfDisintegration.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Disintegration.class;
            this.outQuantity = 1;
        }
    }
}

