/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.CorrosiveGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ParalyticGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ToxicGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.BlobImmunity;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Ooze;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfCorrosion;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class SpellBook_Corrosion
extends SpellBook {
    public SpellBook_Corrosion() {
        this.image = ItemSpriteSheet.CORROSION_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        float procChance = ((float)this.buffedLvl() + 1.0f) / ((float)this.buffedLvl() + 5.0f);
        if (Random.Float() < procChance) {
            Buff.affect(defender, Ooze.class).set(3 + this.buffedLvl());
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        GLog.w(Messages.get(this, "protected", new Object[0]), new Object[0]);
        Buff.prolong(hero, BlobImmunity.class, 5 + this.buffedLvl());
        if (this.buffedLvl() >= 10) {
            GameScene.add(Blob.seed(hero.pos, 300 + 20 * this.buffedLvl(), ParalyticGas.class));
            GameScene.add(Blob.seed(hero.pos, 300 + 20 * this.buffedLvl(), ToxicGas.class));
            GameScene.add(Blob.seed(hero.pos, 150 + 10 * this.buffedLvl(), CorrosiveGas.class));
            Sample.INSTANCE.play("sounds/gas.mp3");
        } else {
            switch (Random.Int(3)) {
                default: {
                    GameScene.add(Blob.seed(hero.pos, 300 + 20 * this.buffedLvl(), ParalyticGas.class));
                    Sample.INSTANCE.play("sounds/gas.mp3");
                    break;
                }
                case 1: {
                    GameScene.add(Blob.seed(hero.pos, 300 + 20 * this.buffedLvl(), ToxicGas.class));
                    Sample.INSTANCE.play("sounds/gas.mp3");
                    break;
                }
                case 2: {
                    GameScene.add(Blob.seed(hero.pos, 150 + 10 * this.buffedLvl(), CorrosiveGas.class));
                    Sample.INSTANCE.play("sounds/gas.mp3");
                }
            }
        }
        needAnimation = busy;
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfCorrosion.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Corrosion.class;
            this.outQuantity = 1;
        }
    }
}

