/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class SpellBook_Blast
extends SpellBook {
    public SpellBook_Blast() {
        this.image = ItemSpriteSheet.BLAST_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        float procChance = ((float)this.buffedLvl() + 1.0f) / ((float)this.buffedLvl() + 5.0f);
        if (Random.Float() < procChance) {
            Buff.affect(defender, Paralysis.class, this.buffedLvl() >= 10 ? 1.0f : 2.0f);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        needAnimation = busy;
        int[] pathFinder = this.buffedLvl() >= 10 ? PathFinder.NEIGHBOURS24 : PathFinder.NEIGHBOURS8;
        for (int i : pathFinder) {
            Char ch = Actor.findChar(hero.pos + i);
            if (ch == null) continue;
            Ballistica trajectory = new Ballistica(hero.pos, ch.pos, 1);
            trajectory = new Ballistica(trajectory.collisionPos, trajectory.path.get(trajectory.path.size() - 1), 7);
            if (this.buffedLvl() >= 10) {
                WandOfBlastWave.throwChar(ch, trajectory, 3 + this.buffedLvl(), true, true, hero.getClass());
                continue;
            }
            WandOfBlastWave.throwChar(ch, trajectory, 2 + this.buffedLvl() / 2, true, true, hero.getClass());
        }
        Sample.INSTANCE.play("sounds/blast.mp3");
        WandOfBlastWave.BlastWave.blast(hero.pos);
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfBlastWave.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Blast.class;
            this.outQuantity = 1;
        }
    }
}

