/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.EnergyWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Sword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WornShortsword;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class WornShortsword_Energy
extends EnergyWeapon {
    public WornShortsword_Energy() {
        this.image = ItemSpriteSheet.WORN_SHORTSWORD_ENERGY;
        this.hitSoundPitch = 1.1f;
        this.tier = 1;
        this.bones = false;
        this.chargePerHit = 2;
        this.chargeUsePerHit = 4;
    }

    @Override
    public int max(int lvl) {
        return 6 * (this.tier + 2) + lvl;
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        if (hero.buff(Sword.CleaveTracker.class) != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Sword.cleaveAbility(hero, target, 1.33f, this);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{WornShortsword.class, ScrollOfUpgrade.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 10};
            this.cost = 8;
            this.output = WornShortsword_Energy.class;
            this.outQuantity = 1;
        }
    }
}

