/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.EnergyWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.NormalKatana;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WornKatana;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class WornKatana_Energy
extends EnergyWeapon {
    public WornKatana_Energy() {
        this.image = ItemSpriteSheet.WORN_KATANA_ENERGY;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.3f;
        this.tier = 1;
        this.bones = false;
        this.chargePerHit = 1;
        this.chargeUsePerHit = 4;
    }

    @Override
    public int max(int lvl) {
        return 6 * (this.tier + 3) + lvl;
    }

    @Override
    public int min(int lvl) {
        return 1;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        NormalKatana.flashSlashAbility(hero, target, 0.5f, this);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{WornKatana.class, ScrollOfUpgrade.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 10};
            this.cost = 8;
            this.output = WornKatana_Energy.class;
            this.outQuantity = 1;
        }
    }
}

