/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Berserk;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bleeding;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SerialAttack;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfArcana;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Dagger;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class UnformedBlade
extends MeleeWeapon {
    public static final String AC_USE = "USE";
    private static final String TXT_STATUS = "%d%%";
    int chargePerHit;
    int chargeUsePerHit;
    int charge = 0;
    int chargeCap = 100;
    boolean use = false;
    private static final String CHARGE = "charge";
    private static final String CHARGE_CAP = "chargeCap";
    private static final String USE = "use";

    public UnformedBlade() {
        this.defaultAction = AC_USE;
        this.image = ItemSpriteSheet.UNFORMED_BLADE;
        this.hitSound = "sounds/hit_stab.mp3";
        this.hitSoundPitch = 0.9f;
        this.chargePerHit = 2;
        this.chargeUsePerHit = 10;
        this.tier = 5;
    }

    @Override
    public int max(int lvl) {
        return 4 * (this.tier + 1) + lvl * (this.tier + 1);
    }

    protected float procChanceMultiplier(Char attacker) {
        SerialAttack serialAttack;
        float multi = RingOfArcana.enchantPowerMultiplier(attacker);
        Berserk rage = attacker.buff(Berserk.class);
        if (rage != null) {
            multi = rage.enchantFactor(multi);
        }
        if (attacker instanceof Hero && ((Hero)attacker).hasTalent(Talent.ARCANE_ATTACK) && (serialAttack = attacker.buff(SerialAttack.class)) != null) {
            multi += (float)serialAttack.getCount() * 0.05f * (float)((Hero)attacker).pointsInTalent(Talent.ARCANE_ATTACK);
        }
        if (attacker.buff(Talent.SpiritBladesTracker.class) != null && ((Hero)attacker).pointsInTalent(Talent.SPIRIT_BLADES) == 4) {
            multi += 0.1f;
        }
        if (attacker.buff(Talent.StrikingWaveTracker.class) != null && ((Hero)attacker).pointsInTalent(Talent.STRIKING_WAVE) == 4) {
            multi += 0.2f;
        }
        if (attacker instanceof Hero && ((Hero)attacker).hasTalent(Talent.MYSTICAL_POWER)) {
            multi += 0.2f * (float)Dungeon.hero.pointsInTalent(Talent.MYSTICAL_POWER);
        }
        return multi;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        Hero hero;
        Char enemy;
        if (attacker instanceof Hero && !this.use && defender instanceof Mob && ((Mob)defender).surprisedBy(Dungeon.hero)) {
            this.charge += this.chargePerHit;
            if (this.charge >= this.chargeCap) {
                this.charge = this.chargeCap;
            }
        }
        if (attacker instanceof Hero && Dungeon.hero.subClass == HeroSubClass.WEAPONMASTER && (enemy = (hero = (Hero)attacker).enemy()) instanceof Mob && ((Mob)enemy).surprisedBy(hero)) {
            Buff.affect(defender, Bleeding.class).set(Math.round(1.0f + (float)damage * 0.2f));
        }
        Item.updateQuickslot();
        if (attacker instanceof Hero && this.use && defender instanceof Mob && ((Mob)defender).surprisedBy(Dungeon.hero)) {
            this.charge -= this.chargeUsePerHit / 2;
            int level = Math.max(0, this.buffedLvl());
            int enemyHealth = defender.HP - damage;
            if (enemyHealth <= 0) {
                if (this.charge < this.chargeUsePerHit) {
                    if (this.charge < 0) {
                        this.charge = 0;
                    }
                    this.use = false;
                    GLog.w(Messages.get(this, "power_off", new Object[0]), new Object[0]);
                }
                return super.proc(attacker, defender, damage);
            }
            float maxChance = 0.5f + 0.05f * (float)level;
            float chanceMulti = (float)Math.pow((float)(defender.HT - enemyHealth) / (float)defender.HT, 2.0);
            float chance = maxChance * chanceMulti;
            chance *= this.procChanceMultiplier(attacker);
            if (Random.Float() < chance) {
                defender.damage(defender.HP, this);
                defender.sprite.emitter().burst(ShadowParticle.UP, 5);
                this.charge -= this.chargeUsePerHit / 2;
                if (this.charge < this.chargeUsePerHit) {
                    if (this.charge < 0) {
                        this.charge = 0;
                    }
                    this.use = false;
                    GLog.w(Messages.get(this, "power_off", new Object[0]), new Object[0]);
                }
            }
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int damageRoll(Char owner) {
        Hero hero;
        Char enemy;
        if (owner instanceof Hero && (enemy = (hero = (Hero)owner).enemy()) instanceof Mob && ((Mob)enemy).surprisedBy(hero)) {
            int diff = this.max() - this.min();
            int damage = this.augment.damageFactor(Random.NormalIntRange(this.min() + Math.round((float)diff * 0.5f), this.max()));
            int exStr = hero.STR() - this.STRReq();
            if (exStr > 0) {
                damage += Random.IntRange(0, exStr);
            }
            return damage;
        }
        return super.damageRoll(owner);
    }

    @Override
    public String desc() {
        return super.desc() + "\n\n" + Messages.get(this, "energy", this.chargePerHit, this.chargeUsePerHit / 2, this.charge, this.chargeCap);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_USE);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_USE)) {
            if (!this.isEquipped(hero)) {
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else if (this.charge >= this.chargeUsePerHit) {
                if (this.use) {
                    this.use = false;
                    GLog.n(Messages.get(this, "power_off", new Object[0]), new Object[0]);
                    curUser.busy();
                    Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
                    UnformedBlade.curUser.sprite.operate(UnformedBlade.curUser.pos);
                } else {
                    this.use = true;
                    GLog.p(Messages.get(this, "power_on", new Object[0]), new Object[0]);
                    curUser.busy();
                    Sample.INSTANCE.play("sounds/burning.mp3", 2.0f, 1.1f);
                    hero.sprite.emitter().start(ShadowParticle.UP, 0.05f, 10);
                    UnformedBlade.curUser.sprite.operate(UnformedBlade.curUser.pos);
                }
            } else {
                GLog.w(Messages.get(this, "no_charge", new Object[0]), new Object[0]);
            }
            Item.updateQuickslot();
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(CHARGE, this.charge);
        bundle.put(CHARGE_CAP, this.chargeCap);
        bundle.put(USE, this.use);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.charge = bundle.getInt(CHARGE);
        this.chargeCap = bundle.getInt(CHARGE_CAP);
        this.use = bundle.getBoolean(USE);
    }

    @Override
    public String status() {
        if (super.status() != null) {
            return super.status();
        }
        return Messages.format(TXT_STATUS, this.charge);
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Dagger.sneakAbility(hero, 3, this);
    }
}

