/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.InfiniteBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Light;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.Riot;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfReload;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ObsidianShield;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RoundShield;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.GameMath;
import com.watabou.utils.Random;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class TacticalShield
extends MeleeWeapon {
    public static final String AC_SHOOT = "SHOOT";
    public static final String AC_RELOAD = "RELOAD";
    public int max_round;
    public int round = 0;
    public float reload_time;
    public boolean silencer = false;
    public boolean short_barrel = false;
    public boolean long_barrel = false;
    public boolean magazine = false;
    public boolean light = false;
    public boolean heavy = false;
    public boolean flash = false;
    private static final String TXT_STATUS = "%d/%d";
    private static final String ROUND = "round";
    private static final String MAX_ROUND = "max_round";
    private static final String RELOAD_TIME = "reload_time";
    private int targetPos;
    private CellSelector.Listener shooter;

    public TacticalShield() {
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.image = ItemSpriteSheet.TACTICAL_SHIELD;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 0.8f;
        this.tier = 7;
        this.alchemy = true;
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                if (target != null) {
                    if (target == curUser.pos) {
                        TacticalShield.this.reload();
                    } else {
                        TacticalShield.this.knockBullet().cast(curUser, target);
                    }
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_ROUND, this.max_round);
        bundle.put(ROUND, this.round);
        bundle.put(RELOAD_TIME, this.reload_time);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.max_round = bundle.getInt(MAX_ROUND);
        this.round = bundle.getInt(ROUND);
        this.reload_time = bundle.getFloat(RELOAD_TIME);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_SHOOT);
            actions.add(AC_RELOAD);
        }
        return actions;
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 0;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        RoundShield.guardAbility(hero, 3, this);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHOOT)) {
            if (!this.isEquipped(hero)) {
                this.usesTargeting = false;
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else if (this.round <= 0) {
                this.reload();
            } else {
                this.usesTargeting = true;
                curUser = hero;
                curItem = this;
                GameScene.selectCell(this.shooter);
            }
        }
        if (action.equals(AC_RELOAD)) {
            this.max_round = 2;
            if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
                this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
            }
            if (this.round == this.max_round) {
                GLog.w(Messages.get(this, "already_loaded", new Object[0]), new Object[0]);
            } else {
                this.reload();
            }
        }
    }

    public void reload() {
        this.max_round = 2;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        curUser.spend(this.reload_time);
        curUser.busy();
        Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
        TacticalShield.curUser.sprite.operate(TacticalShield.curUser.pos);
        this.round = Math.max(this.max_round, this.round);
        GLog.i(Messages.get(this, "reloading", new Object[0]), new Object[0]);
        if (Dungeon.hero.hasTalent(Talent.SAFE_RELOAD) && Dungeon.hero.buff(Talent.ReloadCooldown.class) == null) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(1 + 2 * Dungeon.hero.pointsInTalent(Talent.SAFE_RELOAD));
            Buff.affect(Dungeon.hero, Talent.ReloadCooldown.class, 5.0f);
        }
        TacticalShield.updateQuickslot();
    }

    public int getRound() {
        return this.round;
    }

    public void oneReload() {
        this.max_round = 2;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        ++this.round;
        if (this.round > this.max_round) {
            this.round = this.max_round;
        }
    }

    @Override
    public String status() {
        this.max_round = 2;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        return Messages.format(TXT_STATUS, this.round, this.max_round);
    }

    @Override
    public int STRReq(int lvl) {
        return TacticalShield.STRReq(this.tier, lvl);
    }

    @Override
    public int max(int lvl) {
        return Math.round(2.5f * (float)(this.tier + 1)) + lvl * (this.tier - 2);
    }

    public int Bulletmin(int lvl) {
        return 2 * this.tier + lvl + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    public int Bulletmax(int lvl) {
        return 4 * (this.tier + 1) + lvl * (this.tier + 1) + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    @Override
    public int defenseFactor(Char owner) {
        return 8 + 4 * this.buffedLvl();
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (this.light) {
            damage = (int)((float)damage * 0.75f);
        }
        if (this.heavy) {
            damage = (int)((float)damage * 1.1f);
        }
        if (this.flash && attacker.buff(Light.class) == null) {
            Buff.affect(defender, Blindness.class, 5.0f);
            Buff.affect(attacker, Light.class, 50.0f);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public String info() {
        this.max_round = 2;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        this.reload_time = 4.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
        String info = super.info();
        info = this.levelKnown ? info + "\n\n" + Messages.get(CrudePistol.class, "stats_known", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time)) : info + "\n\n" + Messages.get(CrudePistol.class, "stats_unknown", this.Bulletmin(0), this.Bulletmax(0), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time));
        if (this.silencer) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, "silencer", new Object[0]);
        }
        if (this.short_barrel) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, "short_barrel", new Object[0]);
        }
        if (this.long_barrel) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, "long_barrel", new Object[0]);
        }
        if (this.magazine) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, "magazine", new Object[0]);
        }
        if (this.light) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, "light", new Object[0]);
        }
        if (this.heavy) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, "heavy", new Object[0]);
        }
        if (this.flash) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, "flash", new Object[0]);
        }
        if (Dungeon.isChallenged(8192) && this.levelKnown) {
            info = info + "\n\n" + Messages.get(Item.class, "durability_weapon", this.durability(), this.maxDurability());
        }
        return info;
    }

    @Override
    public String statsInfo() {
        if (this.isIdentified()) {
            return Messages.get(this, "stats_desc", 8 + 4 * this.buffedLvl());
        }
        return Messages.get(this, "typical_stats_desc", 8);
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return this.knockBullet().targetingPos(user, dst);
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    @Override
    protected float baseDelay(Char owner) {
        int encumbrance;
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero && (encumbrance = this.STRReq() - ((Hero)owner).STR()) > 0) {
            delay = (float)((double)delay * Math.pow(1.2, encumbrance));
        }
        return delay;
    }

    public Bullet knockBullet() {
        return new Bullet();
    }

    public class Bullet
    extends MissileWeapon {
        public Bullet() {
            float heroHPPercent = (float)Dungeon.hero.HP / (float)Dungeon.hero.HT;
            if (heroHPPercent < 0.25f) {
                this.image = ItemSpriteSheet.ENERGY_BULLET_1;
            }
            if (heroHPPercent >= 0.75f) {
                this.image = ItemSpriteSheet.ENERGY_BULLET_3;
            }
            if (heroHPPercent >= 0.25f && heroHPPercent < 0.75f) {
                this.image = ItemSpriteSheet.ENERGY_BULLET_2;
            }
            this.hitSound = "sounds/puff.mp3";
            this.tier = 7;
        }

        @Override
        public int buffedLvl() {
            return TacticalShield.this.buffedLvl();
        }

        @Override
        public int damageRoll(Char owner) {
            Hero hero = (Hero)owner;
            Char enemy = hero.enemy();
            int bulletdamage = Random.NormalIntRange(TacticalShield.this.Bulletmin(TacticalShield.this.buffedLvl()), TacticalShield.this.Bulletmax(TacticalShield.this.buffedLvl()));
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
            if (owner.buff(Bless.class) != null && ((Hero)owner).hasTalent(Talent.BLESSED_TALENT)) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.BLESSED_TALENT)));
            }
            return bulletdamage;
        }

        @Override
        public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
            return TacticalShield.this.hasEnchant(type, owner);
        }

        @Override
        public int proc(Char attacker, Char defender, int damage) {
            if (TacticalShield.this.silencer) {
                damage = (int)((float)damage * 0.75f);
            }
            float heroHPPercent = (float)Dungeon.hero.HP / (float)Dungeon.hero.HT;
            damage = (int)((float)damage * GameMath.gate(0.125f, 2.0f * heroHPPercent, 1.5f));
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (TacticalShield.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow != null && bow.enchantment != null) {
                return bow.enchantment.proc(this, attacker, defender, damage);
            }
            if (TacticalShield.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow2 != null && bow2.enchantment != null) {
                return bow2.enchantment.proc(this, attacker, defender, damage);
            }
            if (TacticalShield.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow3 != null && bow3.enchantment != null) {
                return bow3.enchantment.proc(this, attacker, defender, damage);
            }
            if (TacticalShield.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow4 != null && bow4.enchantment != null) {
                return bow4.enchantment.proc(this, attacker, defender, damage);
            }
            if (TacticalShield.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow5 != null && bow5.enchantment != null) {
                return bow5.enchantment.proc(this, attacker, defender, damage);
            }
            return TacticalShield.this.proc(attacker, defender, damage);
        }

        @Override
        public float delayFactor(Char user) {
            if (Dungeon.hero.buff(Riot.riotTracker.class) != null) {
                return TacticalShield.this.delayFactor(user) / 2.0f;
            }
            return TacticalShield.this.delayFactor(user);
        }

        @Override
        public float accuracyFactor(Char owner, Char target) {
            float accFactor = super.accuracyFactor(owner, target);
            if (TacticalShield.this.short_barrel) {
                accFactor = Dungeon.level.adjacent(owner.pos, target.pos) ? (accFactor *= 1.25f) : (accFactor *= 0.75f);
            }
            if (TacticalShield.this.long_barrel) {
                accFactor = Dungeon.level.adjacent(owner.pos, target.pos) ? (accFactor *= 0.75f) : (accFactor *= 1.1f);
            }
            if (TacticalShield.this.magazine && !Dungeon.level.adjacent(owner.pos, target.pos)) {
                accFactor *= 0.85f;
            }
            if (TacticalShield.this.light) {
                accFactor *= 0.9f;
            }
            if (TacticalShield.this.heavy) {
                accFactor *= 1.1f;
            }
            return accFactor;
        }

        @Override
        public int STRReq(int lvl) {
            return TacticalShield.this.STRReq();
        }

        @Override
        protected void onThrow(int cell) {
            float heroHPPercent;
            Char enemy = Actor.findChar(cell);
            if (enemy == null || enemy == curUser) {
                heroHPPercent = (float)Dungeon.hero.HP / (float)Dungeon.hero.HT;
                this.parent = null;
                if (heroHPPercent < 0.25f) {
                    CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 1);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 1);
                }
                if (heroHPPercent >= 0.75f) {
                    CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 3);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 3);
                }
                if (heroHPPercent >= 0.25f && heroHPPercent < 0.75f) {
                    CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
                }
            } else if (!curUser.shoot(enemy, this)) {
                heroHPPercent = (float)Dungeon.hero.HP / (float)Dungeon.hero.HT;
                if (heroHPPercent < 0.25f) {
                    CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 1);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 1);
                }
                if (heroHPPercent >= 0.75f) {
                    CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 3);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 3);
                }
                if (heroHPPercent >= 0.25f && heroHPPercent < 0.75f) {
                    CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
                }
            }
            if (Dungeon.hero.buff(InfiniteBullet.class) == null && (Dungeon.hero.buff(Riot.riotTracker.class) == null || Random.Int(10) > Dungeon.hero.pointsInTalent(Talent.ROUND_PRESERVE) - 1)) {
                --TacticalShield.this.round;
            }
            for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
                if (mob.paralysed > 0 || Dungeon.level.distance(Bullet.curUser.pos, mob.pos) > 4 || mob.state == mob.HUNTING) continue;
                mob.beckon(Bullet.curUser.pos);
            }
        }

        @Override
        public void throwSound() {
            Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.33f, 0.66f));
        }

        @Override
        public void cast(Hero user, int dst) {
            super.cast(user, dst);
        }
    }

    public static class Recipe3
    extends Recipe.SimpleRecipe {
        public Recipe3() {
            this.inputs = new Class[]{ObsidianShield.class, TacticalHandgunHP.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 30};
            this.cost = 5;
            this.output = TacticalShield.class;
            this.outQuantity = 1;
        }
    }

    public static class Recipe2
    extends Recipe.SimpleRecipe {
        public Recipe2() {
            this.inputs = new Class[]{ObsidianShield.class, TacticalHandgunAP.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 30};
            this.cost = 5;
            this.output = TacticalShield.class;
            this.outQuantity = 1;
        }
    }

    public static class Recipe1
    extends Recipe.SimpleRecipe {
        public Recipe1() {
            this.inputs = new Class[]{ObsidianShield.class, TacticalHandgun.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 70};
            this.cost = 15;
            this.output = TacticalShield.class;
            this.outQuantity = 1;
        }
    }
}

