/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShovelDigCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Lucky;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Shovel
extends MeleeWeapon {
    public static final String AC_DIG = "DIG";

    public Shovel() {
        this.defaultAction = AC_DIG;
        this.image = ItemSpriteSheet.SHOVEL;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 1;
        this.unique = true;
        this.bones = false;
        this.canAdvance = true;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_DIG);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_DIG)) {
            if (hero.buff(ShovelDigCoolDown.class) != null) {
                GLog.w(Messages.get(this, "not_ready", new Object[0]), new Object[0]);
            } else {
                this.Dig();
            }
        }
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (attacker == Dungeon.hero && ((Hero)attacker).subClass == HeroSubClass.TREASUREHUNTER && damage >= defender.HP && Random.Float() < (0.1f + 0.04f * (float)this.level()) * (1.0f + 0.5f * (float)Dungeon.hero.pointsInTalent(Talent.FINDING_TREASURE))) {
            Buff.affect(defender, Lucky.LuckProc.class);
        }
        return super.proc(attacker, defender, damage);
    }

    public void Dig() {
        int flowers;
        curUser.spend(1.0f);
        curUser.busy();
        Sample.INSTANCE.play("sounds/trample.mp3", 2.0f, 1.1f);
        Shovel.curUser.sprite.operate(Shovel.curUser.pos);
        GLog.i(Messages.get(this, "dig", new Object[0]), new Object[0]);
        int n = flowers = Random.Int(2) < Dungeon.hero.pointsInTalent(Talent.FLOWER_BED) ? 1 : 0;
        if (Dungeon.hero.subClass == HeroSubClass.RESEARCHER) {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS25) {
                positions.add(i);
            }
            Random.shuffle(positions);
            Object object = positions.iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                int c = Dungeon.level.map[Dungeon.hero.pos + i];
                if (c != 1 && c != 20 && c != 9 && c != 2 && c != 29 && c != 30) continue;
                if (flowers > 0) {
                    Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), Dungeon.hero.pos);
                    --flowers;
                } else if (Random.Int(8) < 1 + Dungeon.hero.pointsInTalent(Talent.ALIVE_GRASS)) {
                    Level.set(Dungeon.hero.pos + i, 15);
                } else {
                    Level.set(Dungeon.hero.pos + i, 30);
                }
                Char enemy = Actor.findChar(Dungeon.hero.pos + i);
                if (enemy instanceof Mob && Dungeon.hero.hasTalent(Talent.ROOT)) {
                    Buff.affect(enemy, Roots.class, 1 + Dungeon.hero.pointsInTalent(Talent.ROOT));
                }
                GameScene.updateMap(Dungeon.hero.pos + i);
                CellEmitter.get(Dungeon.hero.pos + i).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            }
        } else {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS9) {
                positions.add(i);
            }
            Random.shuffle(positions);
            Object object = positions.iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                int c = Dungeon.level.map[Dungeon.hero.pos + i];
                if (c != 1 && c != 20 && c != 9 && c != 2) continue;
                if (flowers > 0) {
                    Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), Dungeon.hero.pos + i);
                    --flowers;
                } else {
                    Level.set(Dungeon.hero.pos + i, 30);
                }
                Char enemy = Actor.findChar(Dungeon.hero.pos + i);
                if (enemy instanceof Mob && Dungeon.hero.hasTalent(Talent.ROOT)) {
                    Buff.affect(enemy, Roots.class, 1 + Dungeon.hero.pointsInTalent(Talent.ROOT));
                }
                GameScene.updateMap(Dungeon.hero.pos + i);
                CellEmitter.get(Dungeon.hero.pos + i).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            }
        }
        if (Random.Int(10) < Dungeon.hero.pointsInTalent(Talent.DETECTOR)) {
            Dungeon.level.drop((Item)Lucky.genLoot(), (int)Dungeon.hero.pos).sprite.drop();
            Lucky.showFlare(Dungeon.hero.sprite);
        }
        Buff.affect(Dungeon.hero, ShovelDigCoolDown.class, Math.max(30 - 2 * this.buffedLvl(), 10));
        if (Dungeon.hero.hasTalent(Talent.PLANT_SHIELD)) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(2 + 3 * Dungeon.hero.pointsInTalent(Talent.PLANT_SHIELD));
        }
    }

    @Override
    public int max(int lvl) {
        if (Dungeon.hero.hasTalent(Talent.TAKEDOWN) && Dungeon.hero.buff(Talent.TakeDownCooldown.class) == null) {
            return 4 * (this.tier + 1) + lvl * (this.tier + 1) + 15 * Dungeon.hero.pointsInTalent(Talent.TAKEDOWN);
        }
        return 4 * (this.tier + 1) + lvl * (this.tier + 1);
    }
}

