/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.AntiMagic;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RoundShield;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.utils.Random;
import java.util.HashSet;

public class ObsidianShield
extends MeleeWeapon {
    public static final HashSet<Class> RESISTS = new HashSet();

    public ObsidianShield() {
        this.image = ItemSpriteSheet.OBSIDIAN_SHIELD;
        this.tier = 6;
    }

    @Override
    public int max(int lvl) {
        return 4 * (this.tier - 1) + lvl * (this.tier - 1);
    }

    @Override
    public int defenseFactor(Char owner) {
        return 4 + 2 * this.buffedLvl();
    }

    public static int drRoll(int level) {
        return Random.NormalIntRange(0, 4 + 2 * level);
    }

    @Override
    public String statsInfo() {
        if (this.isIdentified()) {
            return Messages.get(this, "stats_desc", 4 + 2 * this.buffedLvl());
        }
        return Messages.get(this, "typical_stats_desc", 4);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        RoundShield.guardAbility(hero, 3, this);
    }

    static {
        RESISTS.addAll(AntiMagic.RESISTS);
    }
}

