/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ElectroBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FireBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FrostBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.AmmoBelt;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfReload;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gun;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class NormalGun
extends Gun {
    public CellSelector.Listener shooter;

    public NormalGun() {
        this.reload_time = 2.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                AmmoBelt.OverHeat overHeat = Dungeon.hero.buff(AmmoBelt.OverHeat.class);
                if (target != null) {
                    if (overHeat != null && Random.Float() < AmmoBelt.OverHeat.chance) {
                        NormalGun.this.usesTargeting = false;
                        GLog.w(Messages.get(Gun.class, "failed", new Object[0]), new Object[0]);
                        curUser.spendAndNext(1.0f);
                    } else if (target == curUser.pos) {
                        NormalGun.this.reload();
                    } else {
                        NormalGun.this.knockBullet().cast(curUser, target);
                    }
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public int Bulletmin(int lvl) {
        return 2 * this.tier + lvl + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    @Override
    public int Bulletmax(int lvl) {
        return 4 * (this.tier + 1) + lvl * (this.tier + 1) + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    @Override
    public String status() {
        this.max_round = this.magazine ? 4 : 3;
        return Messages.format("%d/%d", this.round, this.max_round);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("SHOOT")) {
            if (!this.isEquipped(hero)) {
                this.usesTargeting = false;
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else if (this.round <= 0) {
                if (hero.hasTalent(Talent.ELEMENTAL_BULLET)) {
                    this.elementReload();
                } else {
                    this.reload();
                }
            } else {
                this.reload_time = 2.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
                this.usesTargeting = true;
                curUser = hero;
                curItem = this;
                GameScene.selectCell(this.shooter);
            }
        }
        if (action.equals("RELOAD")) {
            if (this.round == this.max_round) {
                GLog.w(Messages.get(this, "already_loaded", new Object[0]), new Object[0]);
            } else if (this.round == 0 && hero.hasTalent(Talent.ELEMENTAL_BULLET)) {
                this.elementReload();
            } else {
                this.reload();
            }
        }
    }

    @Override
    public void reload() {
        Buff.detach(Dungeon.hero, FrostBullet.class);
        Buff.detach(Dungeon.hero, FireBullet.class);
        Buff.detach(Dungeon.hero, ElectroBullet.class);
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round += Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE);
        }
        curUser.spend(this.reload_time);
        curUser.busy();
        Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
        NormalGun.curUser.sprite.operate(NormalGun.curUser.pos);
        this.round = Math.max(this.max_round, this.round);
        GLog.i(Messages.get(this, "reloading", new Object[0]), new Object[0]);
        if (Dungeon.hero.hasTalent(Talent.SAFE_RELOAD) && Dungeon.hero.buff(Talent.ReloadCooldown.class) == null) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(1 + 2 * Dungeon.hero.pointsInTalent(Talent.SAFE_RELOAD));
            Buff.affect(Dungeon.hero, Talent.ReloadCooldown.class, 5.0f);
        }
        NormalGun.updateQuickslot();
    }

    public void elementReload() {
        int chance = Random.Int(6);
        if (Dungeon.hero.pointsInTalent(Talent.ELEMENTAL_BULLET) >= 1 && chance == 0) {
            Buff.affect(Dungeon.hero, FrostBullet.class, 100.0f);
        }
        if (Dungeon.hero.pointsInTalent(Talent.ELEMENTAL_BULLET) >= 2 && chance == 1) {
            Buff.affect(Dungeon.hero, FireBullet.class, 100.0f);
        }
        if (Dungeon.hero.pointsInTalent(Talent.ELEMENTAL_BULLET) == 3 && chance == 2) {
            Buff.affect(Dungeon.hero, ElectroBullet.class, 100.0f);
        }
        super.reload();
    }
}

