/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArtifactRecharge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MonkEnergy;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Regeneration;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.WeaponEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ChainFlail;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Flail;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FrostGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ParalysisGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SleepGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalShield;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Door;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIcon;
import com.shatteredpixel.shatteredpixeldungeon.ui.HeroIcon;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class MeleeWeapon
extends Weapon {
    public static String AC_ABILITY = "ABILITY";
    public int tier;
    private static boolean evaluatingTwinUpgrades = false;
    private static boolean evaluatingWizardUpgrades = false;
    private static CellSelector.Listener dasher = new CellSelector.Listener(){

        @Override
        public void onSelect(final Integer target) {
            Talent.AgressiveMovementAbilityTracker tracker;
            if (target == null || target == -1 || !Dungeon.level.visited[target] && !Dungeon.level.mapped[target]) {
                return;
            }
            PathFinder.buildDistanceMap(target, BArray.or(Dungeon.level.passable, Dungeon.level.avoid, null));
            if (PathFinder.distance[Dungeon.hero.pos] == Integer.MAX_VALUE) {
                GLog.w(Messages.get(MeleeWeapon.class, "dash_bad_position", new Object[0]), new Object[0]);
                return;
            }
            if (Dungeon.hero.rooted) {
                GLog.w(Messages.get(MeleeWeapon.class, "rooted", new Object[0]), new Object[0]);
                return;
            }
            int range = 2;
            if (Dungeon.hero.hasTalent(Talent.SOULIZE)) {
                ++range;
            }
            if (Dungeon.level.distance(Dungeon.hero.pos, target) > range) {
                GLog.w(Messages.get(MeleeWeapon.class, "dash_bad_position", new Object[0]), new Object[0]);
                return;
            }
            Ballistica dash = new Ballistica(Dungeon.hero.pos, target, 7);
            if (Dungeon.hero.pointsInTalent(Talent.SOULIZE) > 1) {
                dash = new Ballistica(Dungeon.hero.pos, target, 5);
                if (Dungeon.hero.pointsInTalent(Talent.SOULIZE) > 2) {
                    dash = new Ballistica(Dungeon.hero.pos, target, 1);
                }
            }
            if (!dash.collisionPos.equals(target) || Actor.findChar(target) != null || Dungeon.level.solid[target] && !Dungeon.level.passable[target] || Dungeon.level.map[target] == 0) {
                GLog.w(Messages.get(MeleeWeapon.class, "dash_bad_position", new Object[0]), new Object[0]);
                return;
            }
            Dungeon.hero.busy();
            Sample.INSTANCE.play("sounds/miss.mp3");
            Dungeon.hero.sprite.emitter().start(Speck.factory(106), 0.01f, Math.round(4.0f + 2.0f * Dungeon.level.trueDistance(Dungeon.hero.pos, target)));
            Dungeon.hero.sprite.jump(Dungeon.hero.pos, target, 0.0f, 0.1f, new Callback(){

                @Override
                public void call() {
                    if (Dungeon.level.map[Dungeon.hero.pos] == 6) {
                        Door.leave(Dungeon.hero.pos);
                    }
                    Dungeon.hero.pos = target;
                    if (Dungeon.hero.pointsInTalent(Talent.AGGRESSIVE_MOVEMENT) > 1) {
                        for (int i : PathFinder.NEIGHBOURS8) {
                            Char ch = Actor.findChar(target + i);
                            if (ch == null || ch.alignment == Char.Alignment.ALLY) continue;
                            ch.damage(Math.round((float)Dungeon.hero.belongings.weapon.damageRoll(Dungeon.hero) * 0.1f), Dungeon.hero);
                            if (Dungeon.hero.pointsInTalent(Talent.AGGRESSIVE_MOVEMENT) <= 2) continue;
                            Buff.affect(ch, Vulnerable.class, 3.0f);
                        }
                        Sample.INSTANCE.play("sounds/blast.mp3");
                        WandOfBlastWave.BlastWave.blast(target);
                        Camera.main.shake(0.5f, 0.5f);
                    }
                    Dungeon.level.occupyCell(Dungeon.hero);
                    Dungeon.hero.next();
                }
            });
            Buff.affect(Dungeon.hero, DashAttack.class).set();
            float chargeToUse = 1.0f;
            if (Dungeon.hero.buff(DashTracker.class) != null) {
                chargeToUse *= 0.5f;
                Dungeon.hero.buff(DashTracker.class).detach();
            }
            if (Dungeon.hero.hasTalent(Talent.CLAM_STEPS)) {
                chargeToUse = (float)((double)chargeToUse * Math.pow(0.795, Dungeon.hero.pointsInTalent(Talent.CLAM_STEPS)));
            }
            if ((tracker = Dungeon.hero.buff(Talent.AgressiveMovementAbilityTracker.class)) != null && tracker.wepAbilUsed) {
                chargeToUse *= 0.5f;
                tracker.detach();
            }
            Dungeon.hero.buff(Charger.class).useCharges(chargeToUse);
            if (Dungeon.hero.hasTalent(Talent.KINETIC_MOVEMENT)) {
                Buff.affect(Dungeon.hero, DashTracker.class).set();
            }
            Item.updateQuickslot();
            AttackIndicator.updateState();
        }

        @Override
        public String prompt() {
            return Messages.get(SpiritBow.class, "prompt", new Object[0]);
        }
    };

    @Override
    public void activate(Char ch) {
        super.activate(ch);
        if (ch instanceof Hero && ch.buff(PrecisionShooting.class) != null) {
            ch.buff(PrecisionShooting.class).detach();
        }
        if (ch instanceof Hero && ((Hero)ch).heroClass == HeroClass.DUELIST) {
            Buff.affect(ch, Charger.class);
        }
        if (ch instanceof Hero && ((Hero)ch).heroClass == HeroClass.DUELIST && this.gun && Dungeon.hero != null && Dungeon.hero.STR() >= this.STRReq()) {
            Buff.affect(ch, PrecisionShooting.class);
        }
        if (ch instanceof Hero && ((Hero)ch).buff(PrecisionShooting.class) != null) {
            if (((Hero)ch).belongings.weapon == null && ((Hero)ch).belongings.secondWep == null) {
                ((Hero)ch).buff(PrecisionShooting.class).detach();
            } else if (((Hero)ch).belongings.weapon == null) {
                if (!((Hero)ch).belongings.secondWep.gun) {
                    ((Hero)ch).buff(PrecisionShooting.class).detach();
                }
            } else if (((Hero)ch).belongings.secondWep == null) {
                if (!((Hero)ch).belongings.weapon.gun) {
                    ((Hero)ch).buff(PrecisionShooting.class).detach();
                }
            } else if (!((Hero)ch).belongings.weapon.gun && !((Hero)ch).belongings.secondWep.gun) {
                ((Hero)ch).buff(PrecisionShooting.class).detach();
            }
        }
    }

    @Override
    public String defaultAction() {
        if (Dungeon.hero != null && Dungeon.hero.heroClass == HeroClass.DUELIST && !this.gun && !(this instanceof TacticalShield)) {
            return AC_ABILITY;
        }
        return super.defaultAction();
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero) && hero.heroClass == HeroClass.DUELIST) {
            actions.add(AC_ABILITY);
        }
        return actions;
    }

    @Override
    public String actionName(String action, Hero hero) {
        if (action.equals(AC_ABILITY)) {
            return Messages.upperCase(Messages.get(this, "ability_name", new Object[0]));
        }
        return super.actionName(action, hero);
    }

    @Override
    public void execute(final Hero hero, String action) {
        super.execute(hero, action);
        if ((this instanceof GrenadeLauncher || this instanceof GrenadeLauncherAP || this instanceof GrenadeLauncherHP || this instanceof SleepGun || this instanceof FrostGun || this instanceof ParalysisGun) && action.equals(AC_ABILITY)) {
            this.execute(hero, this.defaultAction);
            return;
        }
        if (action.equals(AC_ABILITY)) {
            if (!this.isEquipped(hero)) {
                if (hero.hasTalent(Talent.SWIFT_EQUIP)) {
                    if (hero.buff(Talent.SwiftEquipCooldown.class) == null || hero.buff(Talent.SwiftEquipCooldown.class).hasSecondUse()) {
                        this.execute(hero, "EQUIP");
                    } else {
                        GLog.w(Messages.get(this, "ability_need_equip", new Object[0]), new Object[0]);
                        this.usesTargeting = false;
                    }
                } else {
                    GLog.w(Messages.get(this, "ability_need_equip", new Object[0]), new Object[0]);
                    this.usesTargeting = false;
                }
            } else if (this.STRReq() > hero.STR()) {
                GLog.w(Messages.get(this, "ability_low_str", new Object[0]), new Object[0]);
                this.usesTargeting = false;
            } else if (hero.belongings.weapon == this && (float)Buff.affect((Char)hero, Charger.class).charges + Buff.affect((Char)hero, Charger.class).partialCharge < this.abilityChargeUse(hero, null)) {
                GLog.w(Messages.get(this, "ability_no_charge", new Object[0]), new Object[0]);
                this.usesTargeting = false;
            } else if (hero.belongings.secondWep == this && (float)Buff.affect((Char)hero, Charger.class).secondCharges + Buff.affect((Char)hero, Charger.class).secondPartialCharge < this.abilityChargeUse(hero, null)) {
                GLog.w(Messages.get(this, "ability_no_charge", new Object[0]), new Object[0]);
                this.usesTargeting = false;
            } else if (this.targetingPrompt() == null) {
                this.duelistAbility(hero, hero.pos);
                MeleeWeapon.updateQuickslot();
            } else {
                this.usesTargeting = this.useTargeting();
                GameScene.selectCell(new CellSelector.Listener(){

                    @Override
                    public void onSelect(Integer cell) {
                        if (cell != null) {
                            MeleeWeapon.this.duelistAbility(hero, cell);
                            Item.updateQuickslot();
                        }
                    }

                    @Override
                    public String prompt() {
                        return MeleeWeapon.this.targetingPrompt();
                    }
                });
            }
        }
    }

    @Override
    public boolean doEquip(Hero hero) {
        if (super.doEquip(hero)) {
            ActionIndicator.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean equipSecondary(Hero hero) {
        if (super.equipSecondary(hero)) {
            ActionIndicator.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            ActionIndicator.refresh();
            return true;
        }
        return false;
    }

    public String targetingPrompt() {
        return null;
    }

    public boolean useTargeting() {
        return this.targetingPrompt() != null;
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return dst;
    }

    protected void duelistAbility(Hero hero, Integer target) {
    }

    protected void beforeAbilityUsed(Hero hero, Char target) {
        hero.belongings.abilityWeapon = this;
        Charger charger = Buff.affect(hero, Charger.class);
        if (Dungeon.hero.belongings.weapon == this) {
            charger.partialCharge -= this.abilityChargeUse(hero, target);
            while (charger.partialCharge < 0.0f && charger.charges > 0) {
                --charger.charges;
                charger.partialCharge += 1.0f;
            }
        } else {
            charger.secondPartialCharge -= this.abilityChargeUse(hero, target);
            while (charger.secondPartialCharge < 0.0f && charger.secondCharges > 0) {
                --charger.secondCharges;
                charger.secondPartialCharge += 1.0f;
            }
        }
        if (hero.heroClass == HeroClass.DUELIST && hero.hasTalent(Talent.AGGRESSIVE_BARRIER) && (float)hero.HP / (float)hero.HT < 0.2f * (float)(1 + hero.pointsInTalent(Talent.AGGRESSIVE_BARRIER))) {
            Buff.affect(hero, Barrier.class).setShield(3);
        }
        if (hero.hasTalent(Talent.SKILLED_HAND)) {
            Buff.affect(hero, Talent.SkilledHandTracker.class);
        }
        if (hero.buff(Talent.CombinedLethalityAbilityTracker.class) != null && hero.buff(Talent.CombinedLethalityAbilityTracker.class).weapon != null && hero.buff(Talent.CombinedLethalityAbilityTracker.class).weapon != this) {
            Buff.affect(hero, Talent.CombinedLethalityTriggerTracker.class, 5.0f);
        }
        if (hero.hasTalent(Talent.MOMENTARY_UPGRADE)) {
            Buff.affect(hero, WeaponEmpower.class).set(hero.pointsInTalent(Talent.MOMENTARY_UPGRADE), 3.0f);
        }
        MeleeWeapon.updateQuickslot();
    }

    protected void afterAbilityUsed(Hero hero) {
        FlavourBuff tracker;
        hero.belongings.abilityWeapon = null;
        if (hero.hasTalent(Talent.PRECISE_ASSAULT)) {
            Buff.prolong(hero, Talent.PreciseAssaultTracker.class, hero.cooldown() + 4.0f);
        }
        if (hero.hasTalent(Talent.COMBINED_LETHALITY)) {
            tracker = hero.buff(Talent.CombinedLethalityAbilityTracker.class);
            if (tracker == null || ((Talent.CombinedLethalityAbilityTracker)tracker).weapon == this || ((Talent.CombinedLethalityAbilityTracker)tracker).weapon == null) {
                Buff.affect((Char)hero, Talent.CombinedLethalityAbilityTracker.class, (float)hero.cooldown()).weapon = this;
            } else {
                tracker.detach();
            }
        }
        if (hero.hasTalent(Talent.COMBINED_ENERGY)) {
            tracker = hero.buff(Talent.CombinedEnergyAbilityTracker.class);
            if (tracker == null || ((Talent.CombinedEnergyAbilityTracker)tracker).energySpent == -1) {
                Buff.prolong((Char)hero, Talent.CombinedEnergyAbilityTracker.class, (float)hero.cooldown()).wepAbilUsed = true;
            } else {
                ((Talent.CombinedEnergyAbilityTracker)tracker).wepAbilUsed = true;
                Buff.affect(hero, MonkEnergy.class).processCombinedEnergy((Talent.CombinedEnergyAbilityTracker)tracker);
            }
        }
        if (hero.hasTalent(Talent.AGGRESSIVE_MOVEMENT)) {
            tracker = hero.buff(Talent.AgressiveMovementAbilityTracker.class);
            if (tracker == null) {
                Buff.prolong((Char)hero, Talent.AgressiveMovementAbilityTracker.class, (float)hero.cooldown()).wepAbilUsed = true;
            } else {
                ((Talent.AgressiveMovementAbilityTracker)tracker).wepAbilUsed = true;
            }
        }
        if (hero.buff(Talent.CounterAbilityTracker.class) != null) {
            hero.buff(Talent.CounterAbilityTracker.class).detach();
        }
    }

    public static void onAbilityKill(Hero hero, Char killed) {
        if (killed.alignment == Char.Alignment.ENEMY && hero.hasTalent(Talent.LETHAL_HASTE)) {
            Buff.prolong(hero, Haste.class, 1.67f + (float)hero.pointsInTalent(Talent.LETHAL_HASTE));
        }
    }

    protected int baseChargeUse(Hero hero, Char target) {
        return 1;
    }

    public final float abilityChargeUse(Hero hero, Char target) {
        float chargeUse = this.baseChargeUse(hero, target);
        if (hero.buff(Talent.CounterAbilityTracker.class) != null) {
            chargeUse = Math.max(0.0f, chargeUse - 0.5f * (float)hero.pointsInTalent(Talent.COUNTER_ABILITY));
        }
        return chargeUse;
    }

    @Override
    public int min(int lvl) {
        return this.tier + lvl;
    }

    @Override
    public int max(int lvl) {
        return 5 * (this.tier + 1) + lvl * (this.tier + 1);
    }

    @Override
    public int STRReq(int lvl) {
        return MeleeWeapon.STRReq(this.tier, lvl);
    }

    @Override
    public int buffedLvl() {
        int otherLevel;
        KindOfWeapon other;
        if (!evaluatingTwinUpgrades && this.isEquipped(Dungeon.hero) && Dungeon.hero.hasTalent(Talent.TWIN_UPGRADES)) {
            other = null;
            if (Dungeon.hero.belongings.weapon() != this) {
                other = Dungeon.hero.belongings.weapon();
            }
            if (Dungeon.hero.belongings.secondWep() != this) {
                other = Dungeon.hero.belongings.secondWep();
            }
            if (other instanceof MeleeWeapon) {
                evaluatingTwinUpgrades = true;
                otherLevel = other.buffedLvl();
                evaluatingTwinUpgrades = false;
                if (this.tier + (3 - Dungeon.hero.pointsInTalent(Talent.TWIN_UPGRADES)) <= ((MeleeWeapon)other).tier && otherLevel > super.buffedLvl()) {
                    return otherLevel;
                }
            }
        }
        if (!evaluatingWizardUpgrades && this.isEquipped(Dungeon.hero) && Dungeon.hero.subClass == HeroSubClass.WIZARD) {
            other = null;
            if (Dungeon.hero.belongings.weapon() != this) {
                other = Dungeon.hero.belongings.weapon();
            }
            if (other instanceof MeleeWeapon) {
                evaluatingWizardUpgrades = true;
                otherLevel = other.buffedLvl();
                evaluatingWizardUpgrades = false;
                if (otherLevel > super.buffedLvl()) {
                    return otherLevel;
                }
            }
        }
        return super.buffedLvl();
    }

    @Override
    public float accuracyFactor(Char owner, Char target) {
        float ACC = super.accuracyFactor(owner, target);
        if (owner instanceof Hero && ((Hero)owner).hasTalent(Talent.PRECISE_ASSAULT) && ((Hero)owner).belongings.abilityWeapon != this) {
            if (((Hero)owner).heroClass != HeroClass.DUELIST) {
                ACC *= 1.0f + 0.1f * (float)((Hero)owner).pointsInTalent(Talent.PRECISE_ASSAULT);
            } else if (!(this instanceof Flail && owner.buff(Flail.SpinAbilityTracker.class) != null || this instanceof ChainFlail && owner.buff(ChainFlail.SpinAbilityTracker.class) != null || owner.buff(Talent.PreciseAssaultTracker.class) == null)) {
                ACC = (float)((double)ACC * Math.pow(2.0, ((Hero)owner).pointsInTalent(Talent.PRECISE_ASSAULT)));
                owner.buff(Talent.PreciseAssaultTracker.class).detach();
            }
        }
        return ACC;
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    @Override
    public String info() {
        String info = this.desc();
        if (this.levelKnown) {
            info = info + "\n\n" + Messages.get(MeleeWeapon.class, "stats_known", this.tier, this.augment.damageFactor(this.min()), this.augment.damageFactor(this.max()), this.STRReq());
            if (this.STRReq() > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(Weapon.class, "too_heavy", new Object[0]);
            } else if (Dungeon.hero.STR() > this.STRReq()) {
                info = info + " " + Messages.get(Weapon.class, "excess_str", Dungeon.hero.STR() - this.STRReq());
            }
        } else {
            info = info + "\n\n" + Messages.get(MeleeWeapon.class, "stats_unknown", this.tier, this.min(0), this.max(0), this.STRReq(0));
            if (this.STRReq(0) > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(MeleeWeapon.class, "probably_too_heavy", new Object[0]);
            }
        }
        String statsInfo = this.statsInfo();
        if (!statsInfo.equals("")) {
            info = info + "\n\n" + statsInfo;
        }
        switch (this.augment) {
            case SPEED: {
                info = info + " " + Messages.get(Weapon.class, "faster", new Object[0]);
                break;
            }
            case DAMAGE: {
                info = info + " " + Messages.get(Weapon.class, "stronger", new Object[0]);
                break;
            }
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.capitalize(Messages.get(Weapon.class, "enchanted", this.enchantment.name()));
            info = info + " " + this.enchantment.desc();
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = this.enchantment != null && this.enchantment.curse() ? info + "\n\n" + Messages.get(Weapon.class, "weak_cursed", new Object[0]) : info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        if (Dungeon.isChallenged(8192) && this.levelKnown && this.buffedLvl() > 0) {
            info = info + "\n\n" + Messages.get(Item.class, "durability_weapon", this.durability(), this.maxDurability());
        }
        if (Dungeon.hero.heroClass == HeroClass.DUELIST && !(this instanceof MagesStaff)) {
            info = info + "\n\n" + Messages.get(this, "ability_desc", new Object[0]);
        }
        if (this.critChance() > 0 && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(this, "crit_chance", this.critChance());
        }
        return info;
    }

    @Override
    public int maxDurability(int lvl) {
        return 5 * (lvl < 16 ? 16 - lvl : 1);
    }

    public String statsInfo() {
        return Messages.get(this, "stats_desc", new Object[0]);
    }

    @Override
    public String status() {
        if (this.isEquipped(Dungeon.hero) && Dungeon.hero.buff(Charger.class) != null) {
            Charger buff = Dungeon.hero.buff(Charger.class);
            if (Dungeon.hero.belongings.weapon == this) {
                return buff.charges + "/" + buff.chargeCap();
            }
            return buff.secondCharges + "/" + buff.secondChargeCap();
        }
        return super.status();
    }

    @Override
    public int value() {
        int price = 20 * this.tier;
        if (this.hasGoodEnchant()) {
            price = (int)((double)price * 1.5);
        }
        if (this.cursedKnown && (this.cursed || this.hasCurseEnchant())) {
            price /= 2;
        }
        if (this.levelKnown && this.level() > 0) {
            price *= this.level() + 1;
        }
        if (price < 1) {
            price = 1;
        }
        return price;
    }

    public static class PrecisionShooting
    extends Buff {
        public static float HIT_CHARGE_USE = 1.0f;
        public boolean onUse = true;

        public PrecisionShooting() {
            this.announced = true;
            this.type = Buff.buffType.POSITIVE;
        }

        public int hitsLeft() {
            Charger charger = Buff.affect(this.target, Charger.class);
            float charges = charger.charges;
            return (int)((charges += charger.partialCharge) / HIT_CHARGE_USE);
        }

        public int maxHit() {
            Charger charger = Buff.affect(this.target, Charger.class);
            float maxCharges = charger.chargeCap();
            return (int)maxCharges;
        }

        @Override
        public boolean act() {
            if (Dungeon.hero.heroClass != HeroClass.DUELIST) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public int icon() {
            return 151;
        }

        @Override
        public void tintIcon(Image icon) {
            if (this.hitsLeft() == 0 || !this.onUse) {
                icon.brightness(0.25f);
            } else {
                icon.resetColor();
            }
        }

        @Override
        public float iconFadePercent() {
            float usableCharges = (float)this.hitsLeft() * HIT_CHARGE_USE;
            return 1.0f - usableCharges / (float)Buff.affect(this.target, Charger.class).chargeCap();
        }

        @Override
        public String iconTextDisplay() {
            return Integer.toString(this.hitsLeft());
        }

        @Override
        public String desc() {
            if (!this.onUse) {
                return Messages.get(this, "no_use", this.hitsLeft(), this.maxHit());
            }
            return Messages.get(this, "desc", this.hitsLeft(), this.maxHit());
        }
    }

    public static class Charger
    extends Buff
    implements ActionIndicator.Action {
        public int charges = 3;
        public float partialCharge;
        public int secondCharges = 3;
        public float secondPartialCharge;
        public static final String CHARGES = "charges";
        private static final String PARTIALCHARGE = "partialCharge";
        public static final String SECOND_CHARGES = "second_charges";
        private static final String SECOND_PARTIALCHARGE = "second_partialCharge";

        @Override
        public boolean act() {
            if (this.charges < this.chargeCap()) {
                int points;
                if (Regeneration.regenOn()) {
                    this.partialCharge += 1.0f / (40.0f - (float)(this.chargeCap() - this.charges));
                }
                if ((points = ((Hero)this.target).pointsInTalent(Talent.WEAPON_RECHARGING)) > 0 && this.target.buff(Recharging.class) != null || this.target.buff(ArtifactRecharge.class) != null) {
                    this.partialCharge += 1.0f / (14.0f - 4.0f * (float)points);
                }
                if (this.partialCharge >= 1.0f) {
                    ++this.charges;
                    this.partialCharge -= 1.0f;
                    Item.updateQuickslot();
                }
            } else {
                this.partialCharge = 0.0f;
            }
            if (Dungeon.hero.subClass == HeroSubClass.CHAMPION && this.secondCharges < this.secondChargeCap()) {
                if (Regeneration.regenOn()) {
                    this.secondPartialCharge += this.secondChargeMultiplier() / (40.0f - (float)(this.secondChargeCap() - this.secondCharges));
                }
                if (this.secondPartialCharge >= 1.0f) {
                    ++this.secondCharges;
                    this.secondPartialCharge -= 1.0f;
                    Item.updateQuickslot();
                }
            } else {
                this.secondPartialCharge = 0.0f;
            }
            if (ActionIndicator.action != this && (Dungeon.hero.subClass == HeroSubClass.CHAMPION || Dungeon.hero.subClass == HeroSubClass.FENCER)) {
                ActionIndicator.setAction(this);
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public void fx(boolean on) {
            if (on && (Dungeon.hero.subClass == HeroSubClass.CHAMPION || Dungeon.hero.subClass == HeroSubClass.FENCER)) {
                ActionIndicator.setAction(this);
            }
        }

        @Override
        public void detach() {
            super.detach();
            ActionIndicator.clearAction(this);
        }

        public int chargeCap() {
            return Math.min(10, 3 + (Dungeon.hero.lvl - 1) / 3) + Dungeon.hero.pointsInTalent(Talent.ACCUMULATION);
        }

        public int secondChargeCap() {
            return Math.round((float)this.chargeCap() * this.secondChargeMultiplier());
        }

        public float chargeMultiplier() {
            if (this.secondCharges < this.secondChargeCap()) {
                return 1.0f;
            }
            return 1.0f + 0.078f * (float)Dungeon.hero.pointsInTalent(Talent.FASTER_CHARGE);
        }

        public float secondChargeMultiplier() {
            return 0.5f + 0.0834f * (float)Dungeon.hero.pointsInTalent(Talent.SECONDARY_CHARGE);
        }

        public void gainCharge(float charge) {
            if (this.charges < this.chargeCap()) {
                this.partialCharge += charge;
                while (this.partialCharge >= 1.0f) {
                    ++this.charges;
                    this.partialCharge -= 1.0f;
                }
                this.charges = Math.min(this.charges, this.chargeCap());
                Item.updateQuickslot();
            }
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(CHARGES, this.charges);
            bundle.put(PARTIALCHARGE, this.partialCharge);
            bundle.put(SECOND_CHARGES, this.secondCharges);
            bundle.put(SECOND_PARTIALCHARGE, this.secondPartialCharge);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.charges = bundle.getInt(CHARGES);
            this.partialCharge = bundle.getFloat(PARTIALCHARGE);
            this.secondCharges = bundle.getInt(SECOND_CHARGES);
            this.secondPartialCharge = bundle.getFloat(SECOND_PARTIALCHARGE);
        }

        @Override
        public String actionName() {
            if (Dungeon.hero.subClass == HeroSubClass.FENCER) {
                return Messages.get(MeleeWeapon.class, "dash", new Object[0]);
            }
            return Messages.get(MeleeWeapon.class, "swap", new Object[0]);
        }

        @Override
        public int actionIcon() {
            if (Dungeon.hero.subClass == HeroSubClass.CHAMPION) {
                return 109;
            }
            return 0;
        }

        @Override
        public Visual primaryVisual() {
            if (Dungeon.hero.subClass == HeroSubClass.FENCER) {
                BuffIcon ico = new BuffIcon(41, true);
                ico.hardlight(5898418);
                return ico;
            }
            Image ico = Dungeon.hero.belongings.weapon == null ? new HeroIcon(this) : new ItemSprite(Dungeon.hero.belongings.weapon);
            ico.width += 4.0f;
            return ico;
        }

        @Override
        public Visual secondaryVisual() {
            if (Dungeon.hero.subClass == HeroSubClass.CHAMPION) {
                Image ico = Dungeon.hero.belongings.secondWep == null ? new HeroIcon(this) : new ItemSprite(Dungeon.hero.belongings.secondWep);
                ico.scale.set(PixelScene.align(0.51f));
                ico.brightness(0.6f);
                return ico;
            }
            return null;
        }

        @Override
        public int indicatorColor() {
            return 0x5500BB;
        }

        @Override
        public void doAction() {
            if (Dungeon.hero.subClass != HeroSubClass.CHAMPION && Dungeon.hero.subClass != HeroSubClass.FENCER) {
                return;
            }
            if (Dungeon.hero.subClass == HeroSubClass.CHAMPION) {
                if (Dungeon.hero.belongings.secondWep == null && Dungeon.hero.belongings.backpack.items.size() >= Dungeon.hero.belongings.backpack.capacity()) {
                    GLog.w(Messages.get(MeleeWeapon.class, "swap_full", new Object[0]), new Object[0]);
                    return;
                }
                KindOfWeapon temp = Dungeon.hero.belongings.weapon;
                Dungeon.hero.belongings.weapon = Dungeon.hero.belongings.secondWep;
                Dungeon.hero.belongings.secondWep = temp;
                Dungeon.hero.sprite.operate(Dungeon.hero.pos);
                Sample.INSTANCE.play("sounds/unlock.mp3");
                if (Dungeon.hero.buff(Talent.QuickFollowupTracker.class) != null) {
                    Dungeon.hero.buff(Talent.QuickFollowupTracker.class).detach();
                }
                if (Dungeon.hero.buff(Talent.QuickFollowupCooldown.class) == null && Dungeon.hero.hasTalent(Talent.QUICK_FOLLOWUP)) {
                    Buff.affect(Dungeon.hero, Talent.QuickFollowupTracker.class);
                    Buff.affect(Dungeon.hero, Talent.QuickFollowupCooldown.class, 10.0f);
                }
                ActionIndicator.setAction(this);
                Item.updateQuickslot();
                AttackIndicator.updateState();
            } else {
                Talent.AgressiveMovementAbilityTracker tracker;
                float chargeToUse = 1.0f;
                if (Dungeon.hero.buff(DashTracker.class) != null) {
                    chargeToUse *= 0.5f;
                }
                if (Dungeon.hero.hasTalent(Talent.CLAM_STEPS)) {
                    chargeToUse = (float)((double)chargeToUse * Math.pow(0.795, Dungeon.hero.pointsInTalent(Talent.CLAM_STEPS)));
                }
                if ((tracker = Dungeon.hero.buff(Talent.AgressiveMovementAbilityTracker.class)) != null && tracker.wepAbilUsed) {
                    chargeToUse *= 0.5f;
                }
                if ((float)this.charges < chargeToUse) {
                    GLog.w(Messages.get(MeleeWeapon.class, "ability_no_charge", new Object[0]), new Object[0]);
                } else {
                    GameScene.selectCell(dasher);
                }
            }
        }

        public void useCharges(float amount) {
            this.partialCharge -= amount;
            while (this.partialCharge < 0.0f && this.charges > 0) {
                --this.charges;
                this.partialCharge += 1.0f;
            }
        }
    }

    public static class DashTracker
    extends Buff {
        float maxDuration;
        float duration;
        public static final String DURATION = "duration";
        public static final String MAX_DURATION = "maxDuration";

        public DashTracker() {
            this.announced = false;
            this.type = Buff.buffType.POSITIVE;
        }

        public void set() {
            this.duration = this.maxDuration = Dungeon.hero.cooldown() + (float)Dungeon.hero.pointsInTalent(Talent.KINETIC_MOVEMENT);
        }

        @Override
        public boolean act() {
            this.duration -= 1.0f;
            if (this.duration <= 0.0f) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public int icon() {
            return 7;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, 1.0f - this.duration / this.maxDuration);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", Messages.decimalFormat("#.##", this.duration));
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(DURATION, this.duration);
            bundle.put(MAX_DURATION, this.maxDuration);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.duration = bundle.getFloat(DURATION);
            this.maxDuration = bundle.getFloat(MAX_DURATION);
        }
    }

    public static class DashAttack
    extends Buff {
        int duration;
        float dmgMulti;
        public static final String DURATION = "duration";
        public static final String DMG_MULTI = "dmgMulti";

        public DashAttack() {
            this.announced = false;
            this.type = Buff.buffType.POSITIVE;
            this.duration = 0;
            this.dmgMulti = 1.1f;
        }

        public void set() {
            this.dmgMulti = 1.1f * (float)Math.pow(1.05, Dungeon.hero.pointsInTalent(Talent.CRITICAL_MOMENTUM));
        }

        public float getDmgMulti() {
            return this.dmgMulti;
        }

        @Override
        public boolean act() {
            --this.duration;
            if (this.duration <= 0) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(DURATION, this.duration);
            bundle.put(DMG_MULTI, this.dmgMulti);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.duration = bundle.getInt(DURATION);
            this.dmgMulti = bundle.getFloat(DMG_MULTI);
        }
    }
}

