/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LargeSwordBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class LargeSword
extends MeleeWeapon {
    public LargeSword() {
        this.image = ItemSpriteSheet.LARGESWORD;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 0.8f;
        this.tier = 5;
        this.DLY = 2.0f;
    }

    @Override
    public int max(int lvl) {
        return Math.round(6.67f * (float)(this.tier + 1)) + lvl * Math.round(1.33f * (float)(this.tier + 1));
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        this.beforeAbilityUsed(hero, null);
        Buff.affect(hero, LargeSwordBuff.class).setDamageFactor(this.buffedLvl(), 4, Dungeon.hero.belongings.secondWep instanceof LargeSword);
        hero.sprite.operate(hero.pos);
        hero.spendAndNext(1.0f);
        this.afterAbilityUsed(hero);
    }
}

