/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LanceBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Door;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;

public class Lance
extends MeleeWeapon {
    public Lance() {
        this.image = ItemSpriteSheet.LANCE;
        this.hitSound = "sounds/hit_stab.mp3";
        this.hitSoundPitch = 1.2f;
        this.tier = 6;
        this.RCH = 2;
    }

    @Override
    public int max(int lvl) {
        return 4 * this.tier + lvl * this.tier;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Lance.dashAbility(hero, target, this);
    }

    public static void dashAbility(final Hero hero, final Integer target, MeleeWeapon wep) {
        if (target == null || target == -1) {
            return;
        }
        int range = 3;
        if (Dungeon.level.distance(hero.pos, target) > range) {
            GLog.w(Messages.get(MeleeWeapon.class, "ability_bad_position", new Object[0]), new Object[0]);
            return;
        }
        Ballistica dash = new Ballistica(hero.pos, target, 7);
        if (!dash.collisionPos.equals(target) || Actor.findChar(target) != null || Dungeon.level.solid[target] && !Dungeon.level.passable[target]) {
            GLog.w(Messages.get(MeleeWeapon.class, "ability_bad_position", new Object[0]), new Object[0]);
            return;
        }
        wep.beforeAbilityUsed(hero, null);
        Buff.affect(hero, LanceBuff.class).setDamageFactor(2 * (1 + Dungeon.level.distance(hero.pos, target)), hero.belongings.secondWep == wep);
        hero.busy();
        Sample.INSTANCE.play("sounds/miss.mp3");
        hero.sprite.emitter().start(Speck.factory(106), 0.01f, Math.round(4.0f + 2.0f * Dungeon.level.trueDistance(hero.pos, target)));
        hero.sprite.jump(hero.pos, target, 0.0f, 0.1f, new Callback(){

            @Override
            public void call() {
                if (Dungeon.level.map[hero.pos] == 6) {
                    Door.leave(hero.pos);
                }
                hero.pos = target;
                Dungeon.level.occupyCell(hero);
                hero.next();
            }
        });
        wep.afterAbilityUsed(hero);
    }
}

