/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Bible;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HugeSword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import java.util.ArrayList;

public class HolySword
extends MeleeWeapon {
    public HolySword() {
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 7;
        this.alchemy = true;
    }

    @Override
    public int image() {
        if (Dungeon.hero.STR() < this.STRReq()) {
            return ItemSpriteSheet.HOLYSWORD_NORMAL;
        }
        return ItemSpriteSheet.HOLYSWORD_TRUE;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (Dungeon.hero.STR() < this.STRReq()) {
            actions.remove(AC_ABILITY);
        }
        return actions;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (Dungeon.hero.STR() >= this.STRReq()) {
            int healAmt = Math.round((float)damage * 0.4f);
            healAmt = Math.min(healAmt, attacker.HT - Dungeon.hero.HP);
            attacker.heal(healAmt);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int max(int lvl) {
        if (Dungeon.hero.STR() >= this.STRReq()) {
            return 8 * (this.tier + 1) + lvl * (this.tier + 1);
        }
        return 3 * (this.tier - 3) + lvl * (this.tier - 3);
    }

    @Override
    public String desc() {
        if (Dungeon.hero.STR() >= this.STRReq()) {
            return Messages.get(this, "true_desc", new Object[0]);
        }
        return Messages.get(this, "normal_desc", new Object[0]);
    }

    @Override
    protected float baseDelay(Char owner) {
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero) {
            int encumbrance = this.STRReq() - ((Hero)owner).STR();
            delay = encumbrance > 0 ? (float)((double)delay * Math.pow(2.0, encumbrance)) : (delay *= 0.5f);
        }
        return delay;
    }

    @Override
    public String name() {
        if (Dungeon.hero.STR() >= this.STRReq()) {
            String trueName = Messages.get(this, "true_name", new Object[0]);
            return this.enchantment != null && (this.cursedKnown || !this.enchantment.curse()) ? this.enchantment.name(trueName) : trueName;
        }
        String name = Messages.get(this, "name", new Object[0]);
        return this.enchantment != null && (this.cursedKnown || !this.enchantment.curse()) ? this.enchantment.name(name) : name;
    }

    @Override
    public String info() {
        String info = this.desc();
        if (this.levelKnown) {
            info = info + "\n\n" + Messages.get(MeleeWeapon.class, "stats_known", this.tier, this.augment.damageFactor(this.min()), this.augment.damageFactor(this.max()), this.STRReq());
            if (this.STRReq() > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(Weapon.class, "too_heavy", new Object[0]);
            } else if (Dungeon.hero.STR() > this.STRReq()) {
                info = info + " " + Messages.get(Weapon.class, "excess_str", Dungeon.hero.STR() - this.STRReq());
            }
        } else {
            info = info + "\n\n" + Messages.get(MeleeWeapon.class, "stats_unknown", this.tier, this.min(0), this.max(0), this.STRReq(0));
            if (this.STRReq(0) > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(MeleeWeapon.class, "probably_too_heavy", new Object[0]);
            }
        }
        String statsInfo = this.statsInfo();
        if (!statsInfo.equals("")) {
            info = info + "\n\n" + statsInfo;
        }
        switch (this.augment) {
            case SPEED: {
                info = info + " " + Messages.get(Weapon.class, "faster", new Object[0]);
                break;
            }
            case DAMAGE: {
                info = info + " " + Messages.get(Weapon.class, "stronger", new Object[0]);
                break;
            }
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.capitalize(Messages.get(Weapon.class, "enchanted", this.enchantment.name()));
            info = info + " " + this.enchantment.desc();
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = this.enchantment != null && this.enchantment.curse() ? info + "\n\n" + Messages.get(Weapon.class, "weak_cursed", new Object[0]) : info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        if (Dungeon.isChallenged(8192) && this.levelKnown && this.buffedLvl() > 0) {
            info = info + "\n\n" + Messages.get(Item.class, "durability_weapon", this.durability(), this.maxDurability());
        }
        if (Dungeon.hero.heroClass == HeroClass.DUELIST && Dungeon.hero.STR() >= this.STRReq()) {
            info = info + "\n\n" + Messages.get(this, "ability_desc", new Object[0]);
        }
        return info;
    }

    @Override
    public int STRReq(int lvl) {
        return 24;
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        this.beforeAbilityUsed(hero, null);
        Buff.affect(hero, Barrier.class).setShield(Math.round((float)HolySword.curUser.HT * 0.2f));
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/chargeup.mp3");
        hero.next();
        this.afterAbilityUsed(hero);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{HugeSword.class, Bible.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 100};
            this.cost = 10;
            this.output = HolySword.class;
            this.outQuantity = 1;
        }
    }
}

