/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.InfiniteBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.Riot;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Gun
extends MeleeWeapon {
    public static final String AC_SHOOT = "SHOOT";
    public static final String AC_RELOAD = "RELOAD";
    public int max_round;
    public int round;
    public boolean silencer = false;
    public boolean short_barrel = false;
    public boolean long_barrel = false;
    public boolean magazine = false;
    public boolean light = false;
    public boolean heavy = false;
    public boolean flash = false;
    public float reload_time;
    public static final String TXT_STATUS = "%d/%d";
    private static final String ROUND = "round";
    private static final String MAX_ROUND = "max_round";
    private static final String RELOAD_TIME = "reload_time";
    private static final String SILENCER = "silencer";
    private static final String SHORT_BARREL = "short_barrel";
    private static final String LONG_BARREL = "long_barrel";
    private static final String MAGAZINE = "magazine";
    private static final String LIGHT = "light";
    private static final String HEAVY = "heavy";
    private static final String FLASH = "flash";

    public Gun() {
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 0.8f;
        this.bones = false;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_ROUND, this.max_round);
        bundle.put(ROUND, this.round);
        bundle.put(RELOAD_TIME, this.reload_time);
        bundle.put(SILENCER, this.silencer);
        bundle.put(SHORT_BARREL, this.short_barrel);
        bundle.put(LONG_BARREL, this.long_barrel);
        bundle.put(MAGAZINE, this.magazine);
        bundle.put(LIGHT, this.light);
        bundle.put(HEAVY, this.heavy);
        bundle.put(FLASH, this.flash);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.max_round = bundle.getInt(MAX_ROUND);
        this.round = bundle.getInt(ROUND);
        this.reload_time = bundle.getFloat(RELOAD_TIME);
        this.silencer = bundle.getBoolean(SILENCER);
        this.short_barrel = bundle.getBoolean(SHORT_BARREL);
        this.long_barrel = bundle.getBoolean(LONG_BARREL);
        this.magazine = bundle.getBoolean(MAGAZINE);
        this.light = bundle.getBoolean(LIGHT);
        this.heavy = bundle.getBoolean(HEAVY);
        this.flash = bundle.getBoolean(FLASH);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_SHOOT);
            actions.add(AC_RELOAD);
        }
        return actions;
    }

    public void reload() {
    }

    public int getRound() {
        return this.round;
    }

    @Override
    public int STRReq(int lvl) {
        int needSTR = Gun.STRReq(this.tier, lvl);
        if (this.heavy) {
            needSTR += 2;
        }
        if (this.light) {
            needSTR -= 2;
        }
        return needSTR;
    }

    public int Bulletmin(int lvl) {
        return 0;
    }

    public int Bulletmax(int lvl) {
        return 0;
    }

    @Override
    public String info() {
        String info = this.desc();
        if (this.levelKnown) {
            info = info + "\n\n" + Messages.get(MeleeWeapon.class, "stats_known", this.tier, this.augment.damageFactor(this.min()), this.augment.damageFactor(this.max()), this.STRReq());
            if (this.STRReq() > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(Weapon.class, "too_heavy", new Object[0]);
            } else if (Dungeon.hero.STR() > this.STRReq()) {
                info = info + " " + Messages.get(Weapon.class, "excess_str", Dungeon.hero.STR() - this.STRReq());
            }
            info = info + "\n\n" + Messages.get(this, "stats_known", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time));
        } else {
            info = info + "\n\n" + Messages.get(MeleeWeapon.class, "stats_unknown", this.tier, this.min(0), this.max(0), this.STRReq(0));
            if (this.STRReq(0) > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(MeleeWeapon.class, "probably_too_heavy", new Object[0]);
            }
            info = info + "\n\n" + Messages.get(Gun.class, "stats_unknown", this.Bulletmin(0), this.Bulletmax(0), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time));
        }
        String statsInfo = this.statsInfo();
        if (!statsInfo.equals("")) {
            info = info + "\n\n" + statsInfo;
        }
        switch (this.augment) {
            case SPEED: {
                info = info + " " + Messages.get(Weapon.class, "faster", new Object[0]);
                break;
            }
            case DAMAGE: {
                info = info + " " + Messages.get(Weapon.class, "stronger", new Object[0]);
                break;
            }
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.get(Weapon.class, "enchanted", this.enchantment.name());
            info = info + " " + Messages.get(this.enchantment, "desc", new Object[0]);
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        if (this.silencer) {
            info = info + "\n\n" + Messages.get(Gun.class, SILENCER, new Object[0]);
        }
        if (this.short_barrel) {
            info = info + "\n\n" + Messages.get(Gun.class, SHORT_BARREL, new Object[0]);
        }
        if (this.long_barrel) {
            info = info + "\n\n" + Messages.get(Gun.class, LONG_BARREL, new Object[0]);
        }
        if (this.magazine) {
            info = info + "\n\n" + Messages.get(Gun.class, MAGAZINE, new Object[0]);
        }
        if (this.light) {
            info = info + "\n\n" + Messages.get(Gun.class, LIGHT, new Object[0]);
        }
        if (this.heavy) {
            info = info + "\n\n" + Messages.get(Gun.class, HEAVY, new Object[0]);
        }
        if (this.flash) {
            info = info + "\n\n" + Messages.get(Gun.class, FLASH, new Object[0]);
        }
        if (Dungeon.isChallenged(8192) && this.levelKnown) {
            info = info + "\n\n" + Messages.get(Item.class, "durability_weapon", this.durability(), this.maxDurability());
        }
        return info;
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return this.knockBullet().targetingPos(user, dst);
    }

    @Override
    protected float baseDelay(Char owner) {
        int encumbrance;
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero && (encumbrance = this.STRReq() - ((Hero)owner).STR()) > 0) {
            delay = (float)((double)delay * Math.pow(1.2, encumbrance));
        }
        return delay;
    }

    public Bullet knockBullet() {
        return new Bullet();
    }

    public class Bullet
    extends MissileWeapon {
        public Bullet() {
            this.image = ItemSpriteSheet.SINGLE_BULLET;
            this.hitSound = "sounds/puff.mp3";
            this.tier = Gun.this.tier;
        }

        @Override
        public int buffedLvl() {
            return Gun.this.buffedLvl();
        }

        @Override
        public int damageRoll(Char owner) {
            Hero hero = (Hero)owner;
            int bulletdamage = Random.NormalIntRange(Gun.this.Bulletmin(Gun.this.buffedLvl()), Gun.this.Bulletmax(Gun.this.buffedLvl()));
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
            return bulletdamage;
        }

        @Override
        public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
            return Gun.this.hasEnchant(type, owner);
        }

        @Override
        public int proc(Char attacker, Char defender, int damage) {
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (Gun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow != null && bow.enchantment != null) {
                return bow.enchantment.proc(this, attacker, defender, damage);
            }
            if (Gun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow2 != null && bow2.enchantment != null) {
                return bow2.enchantment.proc(this, attacker, defender, damage);
            }
            if (Gun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow3 != null && bow3.enchantment != null) {
                return bow3.enchantment.proc(this, attacker, defender, damage);
            }
            if (Gun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow4 != null && bow4.enchantment != null) {
                return bow4.enchantment.proc(this, attacker, defender, damage);
            }
            if (Gun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow5 != null && bow5.enchantment != null) {
                return bow5.enchantment.proc(this, attacker, defender, damage);
            }
            return Gun.this.proc(attacker, defender, damage);
        }

        @Override
        public float delayFactor(Char user) {
            if (Dungeon.hero.subClass == HeroSubClass.GUNSLINGER && Dungeon.hero.justMoved) {
                return 0.0f;
            }
            if (Dungeon.hero.buff(Riot.riotTracker.class) != null) {
                return Gun.this.delayFactor(user) / 2.0f;
            }
            return Gun.this.delayFactor(user);
        }

        @Override
        public float accuracyFactor(Char owner, Char target) {
            float accFactor = super.accuracyFactor(owner, target);
            return accFactor;
        }

        @Override
        public int STRReq(int lvl) {
            return Gun.this.STRReq();
        }

        @Override
        protected void onThrow(int cell) {
            Char enemy = Actor.findChar(cell);
            if (enemy == null || enemy == curUser) {
                this.parent = null;
                CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
            } else if (!curUser.shoot(enemy, this)) {
                CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
            }
            if (Dungeon.hero.buff(InfiniteBullet.class) == null && (Dungeon.hero.buff(Riot.riotTracker.class) == null || Random.Int(10) > Dungeon.hero.pointsInTalent(Talent.ROUND_PRESERVE) - 1)) {
                --Gun.this.round;
            }
            for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
                if (mob.paralysed > 0 || Dungeon.level.distance(Bullet.curUser.pos, mob.pos) > 4 || mob.state == mob.HUNTING || Gun.this.silencer) continue;
                mob.beckon(Bullet.curUser.pos);
            }
            Bullet.updateQuickslot();
            if (Dungeon.isChallenged(8192)) {
                Gun.this.use();
            }
        }

        @Override
        public void throwSound() {
            Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.33f, 0.66f));
        }

        @Override
        public void cast(Hero user, int dst) {
            super.cast(user, dst);
        }
    }
}

