/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.GrenadeCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.InfiniteBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.Riot;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class GrenadeLauncherHP
extends MeleeWeapon {
    public static final String AC_SHOOT = "SHOOT";
    public static final String AC_RELOAD = "RELOAD";
    public int max_round;
    public int round = 0;
    public float reload_time;
    private static final String TXT_STATUS = "%d/%d";
    private static final String ROUND = "round";
    private static final String MAX_ROUND = "max_round";
    private static final String RELOAD_TIME = "reload_time";
    private int targetPos;
    private CellSelector.Listener shooter;

    public GrenadeLauncherHP() {
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.image = ItemSpriteSheet.HE_LAUNCHER;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 0.8f;
        this.tier = 3;
        this.bones = false;
        this.unique = true;
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                if (target != null) {
                    if (target == curUser.pos) {
                        if (Dungeon.hero.buff(GrenadeCoolDown.class) != null) {
                            GLog.w(Messages.get(GrenadeLauncherHP.class, "cannot_reload", new Object[0]), new Object[0]);
                        } else {
                            GrenadeLauncherHP.this.reload();
                        }
                    } else {
                        GrenadeLauncherHP.this.knockBullet().cast(curUser, target);
                    }
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_ROUND, this.max_round);
        bundle.put(ROUND, this.round);
        bundle.put(RELOAD_TIME, this.reload_time);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.max_round = bundle.getInt(MAX_ROUND);
        this.round = bundle.getInt(ROUND);
        this.reload_time = bundle.getFloat(RELOAD_TIME);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_SHOOT);
        actions.add(AC_RELOAD);
        actions.remove("EQUIP");
        actions.remove(AC_ABILITY);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHOOT)) {
            if (this.round <= 0) {
                this.reload_time = 1.0f;
                if (hero.buff(GrenadeCoolDown.class) != null) {
                    this.usesTargeting = false;
                    GLog.w(Messages.get(GrenadeLauncherHP.class, "cannot_reload", new Object[0]), new Object[0]);
                } else {
                    this.reload();
                }
            } else {
                this.reload_time = 1.0f;
                this.usesTargeting = true;
                curUser = hero;
                curItem = this;
                GameScene.selectCell(this.shooter);
            }
        }
        if (action.equals(AC_RELOAD)) {
            if (hero.buff(GrenadeCoolDown.class) != null) {
                GLog.w(Messages.get(GrenadeLauncherHP.class, "cannot_reload", new Object[0]), new Object[0]);
            } else {
                this.max_round = 1;
                if (this.round == this.max_round) {
                    GLog.w(Messages.get(this, "already_loaded", new Object[0]), new Object[0]);
                } else {
                    this.reload();
                }
            }
        }
    }

    public void reload() {
        this.max_round = 1;
        curUser.spend(this.reload_time);
        curUser.busy();
        Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
        GrenadeLauncherHP.curUser.sprite.operate(GrenadeLauncherHP.curUser.pos);
        this.round = Math.max(this.max_round, this.round);
        GLog.i(Messages.get(this, "reloading", new Object[0]), new Object[0]);
        if (Dungeon.hero.hasTalent(Talent.SAFE_RELOAD) && Dungeon.hero.buff(Talent.ReloadCooldown.class) == null) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(1 + 2 * Dungeon.hero.pointsInTalent(Talent.SAFE_RELOAD));
            Buff.affect(Dungeon.hero, Talent.ReloadCooldown.class, 5.0f);
        }
        GrenadeLauncherHP.updateQuickslot();
    }

    public int getRound() {
        return this.round;
    }

    @Override
    public String status() {
        this.max_round = 1;
        return Messages.format(TXT_STATUS, this.round, this.max_round);
    }

    @Override
    public int STRReq(int lvl) {
        return GrenadeLauncherHP.STRReq(this.tier, lvl);
    }

    @Override
    public int min(int lvl) {
        return this.tier + lvl;
    }

    @Override
    public int max(int lvl) {
        return 2 * (this.tier - 1) + lvl * (this.tier - 1);
    }

    public int Bulletmin(int lvl) {
        int dmg = (int)((float)Dungeon.hero.lvl / 2.5f) + 2 * RingOfSharpshooting.levelDamageBonus(Dungeon.hero) + (this.curseInfusionBonus ? 2 : 0);
        return Math.max(0, dmg);
    }

    public int Bulletmax(int lvl) {
        int dmg = 18 + (int)((float)(Dungeon.hero.lvl * 3) / 2.5f) + 6 * RingOfSharpshooting.levelDamageBonus(Dungeon.hero) + (this.curseInfusionBonus ? 6 : 0);
        return Math.max(0, dmg);
    }

    @Override
    public String info() {
        this.max_round = 1;
        this.reload_time = 1.0f;
        String info = this.desc();
        info = this.levelKnown ? info + "\n\n" + Messages.get(GrenadeLauncherHP.class, "stats_known", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time)) : info + "\n\n" + Messages.get(GrenadeLauncherHP.class, "stats_unknown", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time));
        String statsInfo = this.statsInfo();
        if (!statsInfo.equals("")) {
            info = info + "\n\n" + statsInfo;
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.get(Weapon.class, "enchanted", this.enchantment.name());
            info = info + " " + Messages.get(this.enchantment, "desc", new Object[0]);
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        return info;
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return this.knockBullet().targetingPos(user, dst);
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    @Override
    protected float baseDelay(Char owner) {
        int encumbrance;
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero && (encumbrance = this.STRReq() - ((Hero)owner).STR()) > 0) {
            delay = (float)((double)delay * Math.pow(1.2, encumbrance));
        }
        return delay;
    }

    @Override
    public int level() {
        return (Dungeon.hero == null ? 0 : Dungeon.hero.lvl / 5) + (this.curseInfusionBonus ? 1 : 0);
    }

    @Override
    public int buffedLvl() {
        return this.level();
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    public Rocket knockBullet() {
        return new Rocket();
    }

    public class Rocket
    extends MissileWeapon {
        public Rocket() {
            this.image = ItemSpriteSheet.HE_GRENADE;
            this.hitSound = "sounds/puff.mp3";
            this.tier = 3;
        }

        @Override
        public int buffedLvl() {
            return GrenadeLauncherHP.this.buffedLvl();
        }

        @Override
        public int damageRoll(Char owner) {
            Hero hero = (Hero)owner;
            Char enemy = hero.enemy();
            int bulletdamage = Random.NormalIntRange(GrenadeLauncherHP.this.Bulletmin(GrenadeLauncherHP.this.buffedLvl()), GrenadeLauncherHP.this.Bulletmax(GrenadeLauncherHP.this.buffedLvl()));
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
            if (owner.buff(Bless.class) != null && ((Hero)owner).hasTalent(Talent.BLESSED_TALENT)) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.BLESSED_TALENT)));
            }
            return bulletdamage;
        }

        @Override
        public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
            return GrenadeLauncherHP.this.hasEnchant(type, owner);
        }

        @Override
        public int proc(Char attacker, Char defender, int damage) {
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (GrenadeLauncherHP.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow != null && bow.enchantment != null) {
                return bow.enchantment.proc(this, attacker, defender, damage);
            }
            if (GrenadeLauncherHP.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow2 != null && bow2.enchantment != null) {
                return bow2.enchantment.proc(this, attacker, defender, damage);
            }
            if (GrenadeLauncherHP.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow3 != null && bow3.enchantment != null) {
                return bow3.enchantment.proc(this, attacker, defender, damage);
            }
            if (GrenadeLauncherHP.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow4 != null && bow4.enchantment != null) {
                return bow4.enchantment.proc(this, attacker, defender, damage);
            }
            if (GrenadeLauncherHP.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow5 != null && bow5.enchantment != null) {
                return bow5.enchantment.proc(this, attacker, defender, damage);
            }
            return GrenadeLauncherHP.this.proc(attacker, defender, damage);
        }

        @Override
        public float delayFactor(Char user) {
            if (Dungeon.hero.buff(Riot.riotTracker.class) != null) {
                return GrenadeLauncherHP.this.delayFactor(user) / 2.0f;
            }
            return GrenadeLauncherHP.this.delayFactor(user);
        }

        @Override
        public int STRReq(int lvl) {
            return GrenadeLauncherHP.this.STRReq();
        }

        @Override
        protected void onThrow(int cell) {
            Buff.prolong(Dungeon.hero, GrenadeCoolDown.class, 100.0f);
            Char enemy = Actor.findChar(cell);
            ArrayList<Char> targets = new ArrayList<Char>();
            if (Actor.findChar(cell) != null) {
                targets.add(Actor.findChar(cell));
            }
            for (int i : PathFinder.NEIGHBOURS8) {
                if (Actor.findChar(cell + i) == null) continue;
                targets.add(Actor.findChar(cell + i));
            }
            Object object = targets.iterator();
            while (object.hasNext()) {
                Char target = (Char)object.next();
                curUser.shoot(target, this);
                if (target != Dungeon.hero || target.isAlive()) continue;
                Dungeon.fail(this.getClass());
                GLog.n(Messages.get(GrenadeLauncherHP.class, "ondeath", new Object[0]), new Object[0]);
            }
            CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 6);
            CellEmitter.center(cell).burst(BlastParticle.FACTORY, 6);
            boolean terrainAffected = false;
            ArrayList<Char> affected = new ArrayList<Char>();
            for (int n : PathFinder.NEIGHBOURS9) {
                Char ch;
                int c = cell + n;
                if (c < 0 || c >= Dungeon.level.length()) continue;
                if (Dungeon.level.heroFOV[c]) {
                    CellEmitter.get(c).burst(SmokeParticle.FACTORY, 4);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 4);
                }
                if (Dungeon.level.flamable[c]) {
                    Dungeon.level.destroy(c);
                    GameScene.updateMap(c);
                    terrainAffected = true;
                }
                if ((ch = Actor.findChar(c)) == null) continue;
                affected.add(ch);
            }
            Sample.INSTANCE.play("sounds/blast.mp3");
            if (Dungeon.hero.buff(InfiniteBullet.class) == null && (Dungeon.hero.buff(Riot.riotTracker.class) == null || Random.Int(10) > Dungeon.hero.pointsInTalent(Talent.ROUND_PRESERVE) - 1)) {
                --GrenadeLauncherHP.this.round;
            }
            Rocket.updateQuickslot();
        }

        @Override
        public void throwSound() {
            Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.17f, 0.33f));
        }

        @Override
        public void cast(Hero user, int dst) {
            super.cast(user, dst);
        }
    }
}

