/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Fire;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.InfiniteBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.Riot;
import com.shatteredpixel.shatteredpixeldungeon.effects.MagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.items.AmmoBelt;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfReload;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.ConeAOE;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class FlameThrower
extends MeleeWeapon {
    public static final String AC_SHOOT = "SHOOT";
    public static final String AC_RELOAD = "RELOAD";
    public int max_round;
    public int initial_max_round = 4;
    public int round = 0;
    public float reload_time;
    private static final String TXT_STATUS = "%d/%d";
    int maxDistance;
    int degree;
    private static final String ROUND = "round";
    private static final String MAX_ROUND = "max_round";
    private static final String RELOAD_TIME = "reload_time";
    private int targetPos;
    private CellSelector.Listener shooter;

    public FlameThrower() {
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.image = ItemSpriteSheet.FLAMETHORWER;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 0.8f;
        this.maxDistance = 5;
        this.degree = 30;
        this.tier = 5;
        this.gun = true;
        this.heavyGun = true;
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                AmmoBelt.OverHeat overHeat = Dungeon.hero.buff(AmmoBelt.OverHeat.class);
                if (target != null) {
                    if (overHeat != null && Random.Float() < AmmoBelt.OverHeat.chance) {
                        FlameThrower.this.usesTargeting = false;
                        GLog.w(Messages.get(CrudePistol.class, "failed", new Object[0]), new Object[0]);
                        curUser.spendAndNext(1.0f);
                    } else if (target != null) {
                        if (target == curUser.pos) {
                            FlameThrower.this.reload();
                        } else {
                            FlameThrower.this.knockBullet().cast(curUser, target);
                            if (Dungeon.hero.buff(MeleeWeapon.PrecisionShooting.class) != null && Dungeon.hero.buff(MeleeWeapon.Charger.class) != null && Dungeon.hero.buff(MeleeWeapon.PrecisionShooting.class).onUse && Dungeon.hero.buff(MeleeWeapon.Charger.class).charges >= 1) {
                                --Dungeon.hero.buff(MeleeWeapon.Charger.class).charges;
                            }
                        }
                    }
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_ROUND, this.max_round);
        bundle.put(ROUND, this.round);
        bundle.put(RELOAD_TIME, this.reload_time);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.max_round = bundle.getInt(MAX_ROUND);
        this.round = bundle.getInt(ROUND);
        this.reload_time = bundle.getFloat(RELOAD_TIME);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_SHOOT);
            actions.add(AC_RELOAD);
        }
        return actions;
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 0;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        CrudePistol.shootAbility(hero, this);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHOOT)) {
            if (!this.isEquipped(hero)) {
                this.usesTargeting = false;
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else if (this.round <= 0) {
                this.reload_time = 3.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
                this.reload();
            } else {
                int STRReq = this.STRReq(this.buffedLvl());
                if (this.masteryPotionBonus) {
                    STRReq -= 2;
                }
                if (hero.STR() < STRReq) {
                    this.usesTargeting = false;
                    GLog.w(Messages.get(this, "heavy_to_shoot", new Object[0]), new Object[0]);
                } else {
                    this.reload_time = 3.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
                    this.usesTargeting = true;
                    curUser = hero;
                    curItem = this;
                    GameScene.selectCell(this.shooter);
                }
            }
        }
        if (action.equals(AC_RELOAD)) {
            this.max_round = this.initial_max_round;
            if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
                this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
            }
            if (this.round == this.max_round) {
                GLog.w(Messages.get(this, "already_loaded", new Object[0]), new Object[0]);
            } else {
                this.reload();
            }
        }
    }

    public void reload() {
        this.max_round = this.initial_max_round;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        curUser.spend(this.reload_time);
        curUser.busy();
        Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
        FlameThrower.curUser.sprite.operate(FlameThrower.curUser.pos);
        this.round = Math.max(this.max_round, this.round);
        GLog.i(Messages.get(this, "reloading", new Object[0]), new Object[0]);
        if (Dungeon.hero.hasTalent(Talent.SAFE_RELOAD) && Dungeon.hero.buff(Talent.ReloadCooldown.class) == null) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(1 + 2 * Dungeon.hero.pointsInTalent(Talent.SAFE_RELOAD));
            Buff.affect(Dungeon.hero, Talent.ReloadCooldown.class, 5.0f);
        }
        FlameThrower.updateQuickslot();
    }

    public int getRound() {
        return this.round;
    }

    public void oneReload() {
        this.max_round = this.initial_max_round;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        ++this.round;
        if (this.round > this.max_round) {
            this.round = this.max_round;
        }
    }

    @Override
    public String status() {
        this.max_round = this.initial_max_round;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        return Messages.format(TXT_STATUS, this.round, this.max_round);
    }

    @Override
    public int min(int lvl) {
        return this.tier + lvl;
    }

    @Override
    public int max(int lvl) {
        return 3 * (this.tier + 1) + lvl;
    }

    public int Bulletmin(int lvl) {
        return this.tier + lvl + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    public int Bulletmax(int lvl) {
        return 5 * (this.tier + 1) + lvl * 3 + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    @Override
    public String info() {
        this.max_round = this.initial_max_round;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        this.reload_time = 3.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
        String info = super.info();
        info = this.levelKnown ? info + "\n\n" + Messages.get(CrudePistol.class, "stats_known", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time)) : info + "\n\n" + Messages.get(CrudePistol.class, "stats_unknown", this.Bulletmin(0), this.Bulletmax(0), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time));
        if (Dungeon.isChallenged(8192) && this.levelKnown) {
            info = info + "\n\n" + Messages.get(Item.class, "durability_weapon", this.durability(), this.maxDurability());
        }
        return info;
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return this.knockBullet().targetingPos(user, dst);
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    @Override
    protected float baseDelay(Char owner) {
        int encumbrance;
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero && (encumbrance = this.STRReq() - ((Hero)owner).STR()) > 0) {
            delay = (float)((double)delay * Math.pow(1.2, encumbrance));
        }
        if (Dungeon.hero.buff(Riot.riotTracker.class) != null) {
            delay *= 0.5f;
        }
        return delay;
    }

    public Bullet knockBullet() {
        return new Bullet();
    }

    public class Bullet
    extends MissileWeapon {
        public Bullet() {
            this.image = ItemSpriteSheet.NOTHING;
            this.hitSound = "sounds/puff.mp3";
            this.tier = 5;
        }

        @Override
        public int buffedLvl() {
            return FlameThrower.this.buffedLvl();
        }

        @Override
        public int damageRoll(Char owner) {
            Hero hero = (Hero)owner;
            Char enemy = hero.enemy();
            int bulletdamage = Random.NormalIntRange(FlameThrower.this.Bulletmin(FlameThrower.this.buffedLvl()), FlameThrower.this.Bulletmax(FlameThrower.this.buffedLvl()));
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
            if (owner.buff(Bless.class) != null && ((Hero)owner).hasTalent(Talent.BLESSED_TALENT)) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.BLESSED_TALENT)));
            }
            if (hero.buff(Riot.riotTracker.class) != null) {
                bulletdamage = (int)((float)bulletdamage * 0.5f);
            }
            return bulletdamage;
        }

        @Override
        public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
            return FlameThrower.this.hasEnchant(type, owner);
        }

        @Override
        public int proc(Char attacker, Char defender, int damage) {
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (FlameThrower.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow != null && bow.enchantment != null) {
                return bow.enchantment.proc(this, attacker, defender, damage);
            }
            if (FlameThrower.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow2 != null && bow2.enchantment != null) {
                return bow2.enchantment.proc(this, attacker, defender, damage);
            }
            if (FlameThrower.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow3 != null && bow3.enchantment != null) {
                return bow3.enchantment.proc(this, attacker, defender, damage);
            }
            if (FlameThrower.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow4 != null && bow4.enchantment != null) {
                return bow4.enchantment.proc(this, attacker, defender, damage);
            }
            if (FlameThrower.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow5 != null && bow5.enchantment != null) {
                return bow5.enchantment.proc(this, attacker, defender, damage);
            }
            return FlameThrower.this.proc(attacker, defender, damage);
        }

        @Override
        public float delayFactor(Char user) {
            if (Dungeon.hero.subClass == HeroSubClass.GUNSLINGER && Dungeon.hero.justMoved) {
                return 0.0f;
            }
            if (Dungeon.hero.buff(Riot.riotTracker.class) != null) {
                return FlameThrower.this.delayFactor(user) / 2.0f;
            }
            return FlameThrower.this.delayFactor(user);
        }

        @Override
        public int STRReq(int lvl) {
            return FlameThrower.this.STRReq();
        }

        @Override
        protected void onThrow(int cell) {
            Ballistica aim = new Ballistica(Dungeon.hero.pos, cell, 0);
            int maxDist = FlameThrower.this.maxDistance;
            int dist = Math.min(aim.dist, maxDist);
            ConeAOE cone = new ConeAOE(aim, dist, FlameThrower.this.degree, 13);
            for (Ballistica ray : cone.outerRays) {
                ((MagicMissile)Dungeon.hero.sprite.parent.recycle(MagicMissile.class)).reset(102, (Visual)Dungeon.hero.sprite, (int)ray.path.get(ray.dist), null);
            }
            ArrayList<Char> chars = new ArrayList<Char>();
            for (int cells : cone.cells) {
                Char ch;
                if (Dungeon.level.map[cells] == 5) {
                    Level.set(cells, 6);
                    GameScene.updateMap(cells);
                }
                if (!Dungeon.level.adjacent(Dungeon.hero.pos, cells) || Dungeon.level.flamable[cells]) {
                    GameScene.add(Blob.seed(cells, 2, Fire.class));
                }
                if ((ch = Actor.findChar(cells)) == null || ch.alignment == Dungeon.hero.alignment) continue;
                chars.add(ch);
            }
            for (Char ch : chars) {
                int damage = this.damageRoll(Dungeon.hero);
                damage += Random.NormalIntRange(chars.size(), 3 * chars.size());
                ch.damage(damage -= ch.drRoll(), Dungeon.hero);
            }
            Sample.INSTANCE.play("sounds/burning.mp3", 1.0f);
            MagicMissile.boltFromChar(Dungeon.hero.sprite.parent, 102, Dungeon.hero.sprite, cone.coreRay.path.get(dist * 2 / 3), new Callback(){

                @Override
                public void call() {
                }
            });
            if (Dungeon.hero.buff(InfiniteBullet.class) == null && (Dungeon.hero.buff(Riot.riotTracker.class) == null || Random.Int(10) > Dungeon.hero.pointsInTalent(Talent.ROUND_PRESERVE) - 1)) {
                --FlameThrower.this.round;
            }
            Invisibility.dispel();
            Bullet.updateQuickslot();
            if (Dungeon.isChallenged(8192)) {
                FlameThrower.this.use();
            }
        }

        @Override
        public void throwSound() {
        }

        @Override
        public void cast(Hero user, int dst) {
            super.cast(user, dst);
        }
    }
}

