/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Lightning;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Shocking;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import java.util.ArrayList;

public class EnergyWeapon
extends MeleeWeapon {
    public static final String AC_POWER = "POWER";
    private static final String TXT_STATUS = "%d%%";
    int chargePerHit;
    int chargeUsePerHit;
    int charge = 0;
    int chargeCap = 100;
    boolean power = false;
    private static final String CHARGE = "charge";
    private static final String CHARGE_CAP = "chargeCap";
    private static final String POWER = "power";

    public EnergyWeapon() {
        this.defaultAction = AC_POWER;
        this.alchemy = true;
    }

    @Override
    public String desc() {
        return super.desc() + "\n\n" + Messages.get(this, "energy", this.chargePerHit, this.chargeUsePerHit, this.charge, this.chargeCap);
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (attacker instanceof Hero && !this.power) {
            this.charge += this.chargePerHit;
            if (this.charge >= this.chargeCap) {
                this.charge = this.chargeCap;
            }
        }
        if (attacker instanceof Hero && this.power) {
            ArrayList<Lightning.Arc> arcs = new ArrayList<Lightning.Arc>();
            ArrayList<Char> affected = new ArrayList<Char>();
            affected.clear();
            arcs.clear();
            Shocking.arc(Dungeon.hero, defender, 2, affected, arcs);
            affected.remove(defender);
            for (Char ch : affected) {
                if (ch.alignment == Dungeon.hero.alignment) continue;
                ch.damage(Math.round(0.4f * (float)damage), this);
            }
            Dungeon.hero.sprite.parent.addToFront(new Lightning(arcs, null));
            Sample.INSTANCE.play("sounds/lightning.mp3");
            this.charge -= this.chargeUsePerHit;
            if (this.charge < this.chargeUsePerHit) {
                this.power = false;
                GLog.w(Messages.get(this, "power_off", new Object[0]), new Object[0]);
            }
        }
        Item.updateQuickslot();
        return super.proc(attacker, defender, damage);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_POWER);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_POWER)) {
            if (!this.isEquipped(hero)) {
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else if (this.charge >= this.chargeUsePerHit) {
                if (this.power) {
                    this.power = false;
                    GLog.n(Messages.get(this, "power_off", new Object[0]), new Object[0]);
                    curUser.busy();
                    Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
                    EnergyWeapon.curUser.sprite.operate(EnergyWeapon.curUser.pos);
                } else {
                    this.power = true;
                    GLog.p(Messages.get(this, "power_on", new Object[0]), new Object[0]);
                    curUser.busy();
                    Sample.INSTANCE.play("sounds/chargeup.mp3", 2.0f, 1.1f);
                    EnergyWeapon.curUser.sprite.operate(EnergyWeapon.curUser.pos);
                }
            } else {
                GLog.w(Messages.get(this, "no_charge", new Object[0]), new Object[0]);
            }
            Item.updateQuickslot();
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(CHARGE, this.charge);
        bundle.put(CHARGE_CAP, this.chargeCap);
        bundle.put(POWER, this.power);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.charge = bundle.getInt(CHARGE);
        this.chargeCap = bundle.getInt(CHARGE_CAP);
        this.power = bundle.getBoolean(POWER);
    }

    @Override
    public String status() {
        if (super.status() != null) {
            return super.status();
        }
        return Messages.format(TXT_STATUS, this.charge);
    }
}

