/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SparkParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.brews.ShockingBrew;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Scimitar;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class ElectroScimitar
extends MeleeWeapon {
    public ElectroScimitar() {
        this.image = ItemSpriteSheet.ELECTRO_SCIMITAR;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.2f;
        this.tier = 4;
        this.DLY = 0.67f;
        this.alchemy = true;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if ((double)Random.Int(10) <= Math.floor((float)Dungeon.hero.belongings.weapon.buffedLvl() / 4.0f)) {
            Buff.affect(defender, Paralysis.class, 2.0f);
            defender.sprite.centerEmitter().burst(SparkParticle.FACTORY, 3);
            defender.sprite.flash();
            Sample.INSTANCE.play("sounds/lightning.mp3");
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int max(int lvl) {
        return 4 * (this.tier + 1) + lvl * (this.tier + 1);
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        this.beforeAbilityUsed(hero, null);
        Buff.prolong(hero, Scimitar.SwordDance.class, 5.0f);
        hero.sprite.operate(hero.pos);
        hero.next();
        this.afterAbilityUsed(hero);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Scimitar.class, ShockingBrew.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 60};
            this.cost = 10;
            this.output = ElectroScimitar.class;
            this.outQuantity = 1;
        }
    }
}

