/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bleeding;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class Dagger
extends MeleeWeapon {
    public Dagger() {
        this.image = ItemSpriteSheet.DAGGER;
        this.hitSound = "sounds/hit_stab.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 1;
        this.bones = false;
    }

    @Override
    public int max(int lvl) {
        return 4 * (this.tier + 1) + lvl * (this.tier + 1);
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        Hero hero;
        Char enemy;
        if (attacker instanceof Hero && Dungeon.hero.subClass == HeroSubClass.WEAPONMASTER && (enemy = (hero = (Hero)attacker).enemy()) instanceof Mob && ((Mob)enemy).surprisedBy(hero)) {
            Buff.affect(defender, Bleeding.class).set(Math.round(1.0f + (float)damage * 0.4f));
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int damageRoll(Char owner) {
        Hero hero;
        Char enemy;
        if (owner instanceof Hero && (enemy = (hero = (Hero)owner).enemy()) instanceof Mob && ((Mob)enemy).surprisedBy(hero)) {
            int diff = this.max() - this.min();
            int damage = this.augment.damageFactor(Random.NormalIntRange(this.min() + Math.round((float)diff * 0.75f), this.max()));
            int exStr = hero.STR() - this.STRReq();
            if (exStr > 0) {
                damage += Random.IntRange(0, exStr);
            }
            return damage;
        }
        return super.damageRoll(owner);
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Dagger.sneakAbility(hero, 10, this);
    }

    public static void sneakAbility(Hero hero, int invisTurns, MeleeWeapon wep) {
        wep.beforeAbilityUsed(hero, null);
        Buff.affect(hero, Invisibility.class, invisTurns);
        hero.spendAndNext(1.0f);
        CellEmitter.get(Dungeon.hero.pos).burst(Speck.factory(7), 6);
        Sample.INSTANCE.play("sounds/puff.mp3");
        wep.afterAbilityUsed(hero);
    }
}

