/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Iterator;

public class ChainWhip
extends MeleeWeapon {
    public ChainWhip() {
        this.image = ItemSpriteSheet.CHAIN_WHIP;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 5;
        this.RCH = 4;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (Random.Int(100) < 10 + 2 * Dungeon.hero.belongings.weapon.buffedLvl()) {
            Buff.affect(defender, Paralysis.class, 3.0f);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int max(int lvl) {
        return 3 * (this.tier - 1) + lvl * (this.tier - 2);
    }

    @Override
    protected void duelistAbility(final Hero hero, Integer target) {
        final ArrayList<Char> targets = new ArrayList<Char>();
        Char closest = null;
        hero.belongings.abilityWeapon = this;
        for (Char ch : Actor.chars()) {
            if (ch.alignment != Char.Alignment.ENEMY || hero.isCharmedBy(ch) || !Dungeon.level.heroFOV[ch.pos] || !hero.canAttack(ch)) continue;
            targets.add(ch);
            if (closest != null && !(Dungeon.level.trueDistance(hero.pos, closest.pos) > Dungeon.level.trueDistance(hero.pos, ch.pos))) continue;
            closest = ch;
        }
        hero.belongings.abilityWeapon = null;
        if (targets.isEmpty()) {
            GLog.w(Messages.get(this, "ability_no_target", new Object[0]), new Object[0]);
            return;
        }
        this.throwSound();
        final Char finalClosest = closest;
        hero.sprite.attack(hero.pos, new Callback(){

            @Override
            public void call() {
                ChainWhip.this.beforeAbilityUsed(hero, finalClosest);
                Iterator iterator = targets.iterator();
                while (iterator.hasNext()) {
                    Char ch;
                    hero.attack(ch, 1.0f, 0.0f, (ch = (Char)iterator.next()) == finalClosest ? (float)Char.INFINITE_ACCURACY : 1.0f);
                    if (ch.isAlive()) continue;
                    MeleeWeapon.onAbilityKill(hero, ch);
                }
                Invisibility.dispel();
                hero.spendAndNext(hero.attackDelay());
                ChainWhip.this.afterAbilityUsed(hero);
            }
        });
    }
}

