/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Crossbow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;

public class Ballista
extends MeleeWeapon {
    public Ballista() {
        this.image = ItemSpriteSheet.BALLISTA;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 5;
        this.alchemy = true;
    }

    @Override
    public int max(int lvl) {
        return 4 * this.tier + lvl * (this.tier - 1);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        if (hero.buff(BallistaShot.class) != null) {
            GLog.w(Messages.get(Crossbow.class, "ability_cant_use", new Object[0]), new Object[0]);
            return;
        }
        this.beforeAbilityUsed(hero, null);
        Buff.affect(hero, BallistaShot.class);
        hero.sprite.operate(hero.pos);
        hero.next();
        this.afterAbilityUsed(hero);
    }

    public static class BallistaShot
    extends Buff {
        public BallistaShot() {
            this.announced = true;
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 153;
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Crossbow.class, LiquidMetal.class};
            this.inQuantity = new int[]{2, 50};
            this.cost = 8;
            this.output = Ballista.class;
            this.outQuantity = 1;
        }
    }
}

