/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cloaking;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.InfiniteBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Light;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.Riot;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.AmmoBelt;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfReload;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.GunSmithingTool;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class AutoRifle
extends MeleeWeapon {
    public static final String AC_SHOOT = "SHOOT";
    public static final String AC_RELOAD = "RELOAD";
    public static final String AC_AUTO = "AUTO";
    public int max_round;
    public int round = 0;
    public float reload_time;
    public boolean silencer = false;
    public boolean short_barrel = false;
    public boolean long_barrel = false;
    public boolean magazine = false;
    public boolean light = false;
    public boolean heavy = false;
    public boolean flash = false;
    public boolean auto = false;
    private static final String TXT_STATUS = "%d/%d";
    private static final String ROUND = "round";
    private static final String MAX_ROUND = "max_round";
    private static final String RELOAD_TIME = "reload_time";
    private static final String SILENCER = "silencer";
    private static final String SHORT_BARREL = "short_barrel";
    private static final String LONG_BARREL = "long_barrel";
    private static final String MAGAZINE = "magazine";
    private static final String LIGHT = "light";
    private static final String HEAVY = "heavy";
    private static final String FLASH = "flash";
    private static final String AUTO = "auto";
    private int targetPos;
    private CellSelector.Listener shooter;

    public AutoRifle() {
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.image = ItemSpriteSheet.AUTO_RIFLE;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 0.8f;
        this.tier = 5;
        this.alchemy = true;
        this.gun = true;
        this.machineGun = true;
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                AmmoBelt.OverHeat overHeat = Dungeon.hero.buff(AmmoBelt.OverHeat.class);
                if (target != null) {
                    if (overHeat != null && Random.Float() < AmmoBelt.OverHeat.chance) {
                        AutoRifle.this.usesTargeting = false;
                        GLog.w(Messages.get(CrudePistol.class, "failed", new Object[0]), new Object[0]);
                        curUser.spendAndNext(1.0f);
                    } else if (target != null) {
                        if (target == curUser.pos) {
                            AutoRifle.this.reload();
                        } else {
                            AutoRifle.this.knockBullet().cast(curUser, target);
                            if (Dungeon.hero.buff(MeleeWeapon.PrecisionShooting.class) != null && Dungeon.hero.buff(MeleeWeapon.Charger.class) != null && Dungeon.hero.buff(MeleeWeapon.PrecisionShooting.class).onUse && Dungeon.hero.buff(MeleeWeapon.Charger.class).charges >= 1) {
                                AutoRifle.this.beforeAbilityUsed(curUser, Actor.findChar(target));
                                --Dungeon.hero.buff(MeleeWeapon.Charger.class).charges;
                                AutoRifle.this.afterAbilityUsed(curUser);
                            }
                        }
                    }
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_ROUND, this.max_round);
        bundle.put(ROUND, this.round);
        bundle.put(RELOAD_TIME, this.reload_time);
        bundle.put(SILENCER, this.silencer);
        bundle.put(SHORT_BARREL, this.short_barrel);
        bundle.put(LONG_BARREL, this.long_barrel);
        bundle.put(MAGAZINE, this.magazine);
        bundle.put(LIGHT, this.light);
        bundle.put(HEAVY, this.heavy);
        bundle.put(FLASH, this.flash);
        bundle.put(AUTO, this.auto);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.max_round = bundle.getInt(MAX_ROUND);
        this.round = bundle.getInt(ROUND);
        this.reload_time = bundle.getFloat(RELOAD_TIME);
        this.silencer = bundle.getBoolean(SILENCER);
        this.short_barrel = bundle.getBoolean(SHORT_BARREL);
        this.long_barrel = bundle.getBoolean(LONG_BARREL);
        this.magazine = bundle.getBoolean(MAGAZINE);
        this.light = bundle.getBoolean(LIGHT);
        this.heavy = bundle.getBoolean(HEAVY);
        this.flash = bundle.getBoolean(FLASH);
        this.auto = bundle.getBoolean(AUTO);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_SHOOT);
            actions.add(AC_RELOAD);
            actions.add(AC_AUTO);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHOOT)) {
            if (!this.isEquipped(hero)) {
                this.usesTargeting = false;
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else if (this.round <= 0) {
                this.reload_time = 2.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
                this.reload();
            } else {
                this.reload_time = 2.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
                this.usesTargeting = true;
                curUser = hero;
                curItem = this;
                GameScene.selectCell(this.shooter);
            }
        }
        if (action.equals(AC_RELOAD)) {
            int n = this.max_round = this.magazine ? 15 : 12;
            if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
                this.max_round = (int)((float)this.max_round + 3.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
            }
            if (this.round == this.max_round) {
                GLog.w(Messages.get(this, "already_loaded", new Object[0]), new Object[0]);
            } else {
                this.reload();
            }
        }
        if (action.equals(AC_AUTO)) {
            if (this.auto) {
                this.auto = false;
                GLog.i(Messages.get(AutoHandgun.class, "semi", new Object[0]), new Object[0]);
            } else {
                this.auto = true;
                GLog.i(Messages.get(AutoHandgun.class, AUTO, new Object[0]), new Object[0]);
            }
            curUser.spend(1.0f);
            curUser.busy();
            Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
            AutoRifle.curUser.sprite.operate(AutoRifle.curUser.pos);
        }
    }

    public void reload() {
        int n = this.max_round = this.magazine ? 15 : 12;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 3.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        curUser.spend(this.reload_time);
        curUser.busy();
        Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
        AutoRifle.curUser.sprite.operate(AutoRifle.curUser.pos);
        this.round = Math.max(this.max_round, this.round);
        GLog.i(Messages.get(this, "reloading", new Object[0]), new Object[0]);
        if (Dungeon.hero.hasTalent(Talent.SAFE_RELOAD) && Dungeon.hero.buff(Talent.ReloadCooldown.class) == null) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(1 + 2 * Dungeon.hero.pointsInTalent(Talent.SAFE_RELOAD));
            Buff.affect(Dungeon.hero, Talent.ReloadCooldown.class, 5.0f);
        }
        AutoRifle.updateQuickslot();
    }

    public int getRound() {
        return this.round;
    }

    public void oneReload() {
        int n = this.max_round = this.magazine ? 15 : 12;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 3.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        ++this.round;
        if (this.round > this.max_round) {
            this.round = this.max_round;
        }
    }

    @Override
    public String status() {
        int n = this.max_round = this.magazine ? 15 : 12;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 3.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        return Messages.format(TXT_STATUS, this.round, this.max_round);
    }

    @Override
    public int STRReq(int lvl) {
        int needSTR = AutoRifle.STRReq(this.tier, lvl);
        if (this.heavy) {
            needSTR += 2;
        }
        if (this.light) {
            needSTR -= 2;
        }
        return needSTR;
    }

    @Override
    public int min(int lvl) {
        return this.tier + lvl;
    }

    @Override
    public int max(int lvl) {
        return 3 * (this.tier + 1) + lvl * (this.tier + 1);
    }

    public int Bulletmin(int lvl) {
        return this.tier + lvl + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    public int Bulletmax(int lvl) {
        if (this.auto) {
            return 2 * this.tier + lvl * (this.tier - 2) + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
        }
        return 4 * this.tier + lvl * this.tier + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (this.light) {
            damage = (int)((float)damage * 0.75f);
        }
        if (this.heavy) {
            damage = (int)((float)damage * 1.1f);
        }
        if (this.flash && attacker.buff(Light.class) == null) {
            Buff.affect(defender, Blindness.class, 5.0f);
            Buff.affect(attacker, Light.class, 50.0f);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public String info() {
        int n = this.max_round = this.magazine ? 15 : 12;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 3.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        this.reload_time = 2.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
        String info = super.info();
        info = this.levelKnown ? info + "\n\n" + Messages.get(CrudePistol.class, "stats_known", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time)) : info + "\n\n" + Messages.get(CrudePistol.class, "stats_unknown", this.Bulletmin(0), this.Bulletmax(0), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time));
        if (this.silencer) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, SILENCER, new Object[0]);
        }
        if (this.short_barrel) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, SHORT_BARREL, new Object[0]);
        }
        if (this.long_barrel) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, LONG_BARREL, new Object[0]);
        }
        if (this.magazine) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, MAGAZINE, new Object[0]);
        }
        if (this.light) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, LIGHT, new Object[0]);
        }
        if (this.heavy) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, HEAVY, new Object[0]);
        }
        if (this.flash) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, FLASH, new Object[0]);
        }
        if (Dungeon.isChallenged(8192) && this.levelKnown) {
            info = info + "\n\n" + Messages.get(Item.class, "durability_weapon", this.durability(), this.maxDurability());
        }
        return info;
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return this.knockBullet().targetingPos(user, dst);
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    @Override
    protected float baseDelay(Char owner) {
        int encumbrance;
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero && (encumbrance = this.STRReq() - ((Hero)owner).STR()) > 0) {
            delay = (float)((double)delay * Math.pow(1.2, encumbrance));
        }
        return delay;
    }

    public Bullet knockBullet() {
        return new Bullet();
    }

    public class Bullet
    extends MissileWeapon {
        public Bullet() {
            this.image = AutoRifle.this.auto ? ItemSpriteSheet.TRIPLE_BULLET : ItemSpriteSheet.SINGLE_BULLET;
            this.hitSound = "sounds/puff.mp3";
            this.tier = 5;
            this.ACC = 0.7f;
            this.bullet = true;
            this.machineGunBullet = true;
        }

        @Override
        public int buffedLvl() {
            return AutoRifle.this.buffedLvl();
        }

        @Override
        public int damageRoll(Char owner) {
            Hero hero = (Hero)owner;
            Char enemy = hero.enemy();
            int bulletdamage = Random.NormalIntRange(AutoRifle.this.Bulletmin(AutoRifle.this.buffedLvl()), AutoRifle.this.Bulletmax(AutoRifle.this.buffedLvl()));
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
            if (owner.buff(Bless.class) != null && ((Hero)owner).hasTalent(Talent.BLESSED_TALENT)) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.BLESSED_TALENT)));
            }
            return bulletdamage;
        }

        @Override
        public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
            return AutoRifle.this.hasEnchant(type, owner);
        }

        @Override
        public int proc(Char attacker, Char defender, int damage) {
            if (AutoRifle.this.silencer) {
                damage = (int)((float)damage * 0.75f);
            }
            if (damage >= defender.HP && Dungeon.hero.buff(MeleeWeapon.PrecisionShooting.class) != null && Dungeon.hero.buff(MeleeWeapon.Charger.class).charges >= 1) {
                AutoRifle.onAbilityKill(Dungeon.hero, defender);
            }
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (AutoRifle.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow != null && bow.enchantment != null) {
                return bow.enchantment.proc(this, attacker, defender, damage);
            }
            if (AutoRifle.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow2 != null && bow2.enchantment != null) {
                return bow2.enchantment.proc(this, attacker, defender, damage);
            }
            if (AutoRifle.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow3 != null && bow3.enchantment != null) {
                return bow3.enchantment.proc(this, attacker, defender, damage);
            }
            if (AutoRifle.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow4 != null && bow4.enchantment != null) {
                return bow4.enchantment.proc(this, attacker, defender, damage);
            }
            if (AutoRifle.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow5 != null && bow5.enchantment != null) {
                return bow5.enchantment.proc(this, attacker, defender, damage);
            }
            return AutoRifle.this.proc(attacker, defender, damage);
        }

        @Override
        public float delayFactor(Char user) {
            if (Dungeon.hero.buff(Riot.riotTracker.class) != null) {
                return AutoRifle.this.delayFactor(user) / 2.0f;
            }
            return AutoRifle.this.delayFactor(user);
        }

        @Override
        public float accuracyFactor(Char owner, Char target) {
            float accFactor = super.accuracyFactor(owner, target);
            if (AutoRifle.this.short_barrel) {
                accFactor = Dungeon.level.adjacent(owner.pos, target.pos) ? (accFactor *= 1.25f) : (accFactor *= 0.75f);
            }
            if (AutoRifle.this.long_barrel) {
                accFactor = Dungeon.level.adjacent(owner.pos, target.pos) ? (accFactor *= 0.75f) : (accFactor *= 1.1f);
            }
            if (AutoRifle.this.magazine && !Dungeon.level.adjacent(owner.pos, target.pos)) {
                accFactor *= 0.85f;
            }
            if (AutoRifle.this.light) {
                accFactor *= 0.9f;
            }
            if (AutoRifle.this.heavy) {
                accFactor *= 1.1f;
            }
            return accFactor;
        }

        @Override
        public int STRReq(int lvl) {
            return AutoRifle.this.STRReq();
        }

        @Override
        protected void onThrow(int cell) {
            if (AutoRifle.this.auto) {
                for (int i = 1; i <= 3 && AutoRifle.this.round > 0; ++i) {
                    Char enemy = Actor.findChar(cell);
                    if (enemy == null || enemy == curUser) {
                        this.parent = null;
                        CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                        CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
                    } else if (!curUser.shoot(enemy, this)) {
                        CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                        CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
                    }
                    if (Dungeon.hero.buff(InfiniteBullet.class) != null || Dungeon.hero.buff(Riot.riotTracker.class) != null && Random.Int(10) <= Dungeon.hero.pointsInTalent(Talent.ROUND_PRESERVE) - 1) continue;
                    --AutoRifle.this.round;
                }
            } else {
                Char enemy = Actor.findChar(cell);
                if (enemy == null || enemy == curUser) {
                    this.parent = null;
                    CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
                } else if (!curUser.shoot(enemy, this)) {
                    CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                    CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
                }
                if (Dungeon.hero.buff(InfiniteBullet.class) == null && (Dungeon.hero.buff(Riot.riotTracker.class) == null || Random.Int(10) > Dungeon.hero.pointsInTalent(Talent.ROUND_PRESERVE) - 1)) {
                    --AutoRifle.this.round;
                }
            }
            if (Dungeon.hero.pointsInTalent(Talent.SILENCER) > 1) {
                if (Dungeon.hero.pointsInTalent(Talent.SILENCER) <= 2 && Dungeon.hero.buff(Cloaking.class) != null) {
                    // empty if block
                }
            } else {
                for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
                    int dist = 4;
                    if (Dungeon.hero.hasTalent(Talent.SILENCER) && Dungeon.hero.buff(Cloaking.class) != null) {
                        dist = (int)((double)dist * 0.5);
                    }
                    if (mob.paralysed > 0 || Dungeon.level.distance(Bullet.curUser.pos, mob.pos) > dist || mob.state == mob.HUNTING || AutoRifle.this.silencer) continue;
                    mob.beckon(Bullet.curUser.pos);
                }
            }
            Bullet.updateQuickslot();
            if (Dungeon.isChallenged(8192)) {
                AutoRifle.this.use();
            }
        }

        @Override
        public void throwSound() {
            Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.33f, 0.66f));
        }

        @Override
        public void cast(Hero user, int dst) {
            super.cast(user, dst);
        }
    }

    public static class Recipe3
    extends Recipe.SimpleRecipe {
        public Recipe3() {
            this.inputs = new Class[]{HeavyMachinegunHP.class, GunSmithingTool.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 2, 40};
            this.cost = 0;
            this.output = AutoRifle.class;
            this.outQuantity = 1;
        }
    }

    public static class Recipe2
    extends Recipe.SimpleRecipe {
        public Recipe2() {
            this.inputs = new Class[]{HeavyMachinegunAP.class, GunSmithingTool.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 2, 40};
            this.cost = 0;
            this.output = AutoRifle.class;
            this.outQuantity = 1;
        }
    }

    public static class Recipe1
    extends Recipe.SimpleRecipe {
        public Recipe1() {
            this.inputs = new Class[]{HeavyMachinegun.class, GunSmithingTool.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 2, 40};
            this.cost = 0;
            this.output = AutoRifle.class;
            this.outQuantity = 1;
        }
    }
}

