/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bleeding;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssassinsBlade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Glaive;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class AssassinsSpear
extends MeleeWeapon {
    public AssassinsSpear() {
        this.image = ItemSpriteSheet.ASSASSINS_SPEAR;
        this.hitSound = "sounds/hit_stab.mp3";
        this.hitSoundPitch = 0.9f;
        this.tier = 5;
        this.DLY = 1.5f;
        this.RCH = 2;
        this.alchemy = true;
    }

    @Override
    public int max(int lvl) {
        return 4 * this.tier + lvl * this.tier;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        Hero hero;
        Char enemy;
        if (attacker instanceof Hero && Dungeon.hero.subClass == HeroSubClass.WEAPONMASTER && (enemy = (hero = (Hero)attacker).enemy()) instanceof Mob && ((Mob)enemy).surprisedBy(hero)) {
            Buff.affect(defender, Bleeding.class).set(Math.round(1.0f + (float)damage * 0.2f));
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int damageRoll(Char owner) {
        Hero hero;
        Char enemy;
        if (owner instanceof Hero && (enemy = (hero = (Hero)owner).enemy()) instanceof Mob && ((Mob)enemy).surprisedBy(hero)) {
            int diff = this.max() - this.min();
            int damage = this.augment.damageFactor(Random.NormalIntRange(this.min() + Math.round((float)diff * 0.5f), this.max()));
            int exStr = hero.STR() - this.STRReq();
            if (exStr > 0) {
                damage += Random.IntRange(0, exStr);
            }
            return damage;
        }
        return super.damageRoll(owner);
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        AssassinsSpear.assassinSpikeAbility(hero, target, 1.4f, this);
    }

    public static void assassinSpikeAbility(final Hero hero, Integer target, final float dmgMulti, final MeleeWeapon wep) {
        if (target == null) {
            return;
        }
        final Char enemy = Actor.findChar(target);
        if (enemy == null || enemy == hero || hero.isCharmedBy(enemy)) {
            GLog.w(Messages.get(wep, "ability_no_target", new Object[0]), new Object[0]);
            return;
        }
        hero.belongings.abilityWeapon = wep;
        if (!hero.canAttack(enemy)) {
            GLog.w(Messages.get(wep, "ability_bad_position", new Object[0]), new Object[0]);
            hero.belongings.abilityWeapon = null;
            return;
        }
        hero.belongings.abilityWeapon = null;
        hero.sprite.attack(enemy.pos, new Callback(){

            @Override
            public void call() {
                wep.beforeAbilityUsed(hero, enemy);
                AttackIndicator.target(enemy);
                if (hero.attack(enemy, dmgMulti, 0.0f, 0.25f)) {
                    Sample.INSTANCE.play("sounds/hit_strong.mp3");
                }
                Invisibility.dispel();
                hero.spendAndNext(hero.attackDelay());
                if (!enemy.isAlive()) {
                    MeleeWeapon.onAbilityKill(hero, enemy);
                }
                wep.afterAbilityUsed(hero);
            }
        });
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Glaive.class, AssassinsBlade.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 50};
            this.cost = 10;
            this.output = AssassinsSpear.class;
            this.outQuantity = 1;
        }
    }
}

