/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Poison;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.PoisonParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TrueRunicBlade;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.watabou.utils.Random;

public class Venomous
extends Weapon.Enchantment {
    private static ItemSprite.Glowing PURPLE = new ItemSprite.Glowing(0x4400AA);

    @Override
    public int proc(Weapon weapon, Char attacker, Char defender, int damage) {
        int level = Math.max(0, weapon.level());
        float procChance = weapon instanceof TrueRunicBlade ? 1.0f : ((float)level + 1.0f) / ((float)level + 3.0f) * this.procChanceMultiplier(attacker);
        float powerMulti = Math.max(1.0f, procChance);
        if (Random.Float() < procChance) {
            Buff.affect(defender, Poison.class).extend((float)(level / 2 + 1) * powerMulti);
            CellEmitter.center(defender.pos).burst(PoisonParticle.SPLASH, 5);
        }
        return damage;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return PURPLE;
    }
}

