/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TrueRunicBlade;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.watabou.utils.Random;

public class Shiny
extends Weapon.Enchantment {
    private static ItemSprite.Glowing YELLOW = new ItemSprite.Glowing(0xFFFF00);

    @Override
    public int proc(Weapon weapon, Char attacker, Char defender, int damage) {
        int level = Math.max(0, weapon.level());
        float procChance = weapon instanceof TrueRunicBlade ? ((float)level + 1.0f) / ((float)level + 2.0f) * this.procChanceMultiplier(attacker) : ((float)level + 1.0f) / ((float)level + 5.0f) * this.procChanceMultiplier(attacker);
        float powerMulti = Math.max(1.0f, procChance);
        if (Random.Float() < procChance) {
            Buff.prolong(defender, Blindness.class, Random.Float(1.0f, (1.0f + (float)level) * powerMulti));
            Buff.prolong(defender, Cripple.class, Random.Float(1.0f, (1.0f + (float)level / 2.0f) * powerMulti));
            defender.sprite.emitter().burst(Speck.factory(2), 6);
        }
        return damage;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return YELLOW;
    }
}

