/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGun;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.APBullet;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.Evolution;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifleAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssultRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssultRifleAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoHandgunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoRifleAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Carbine;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CarbineAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistolAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.DualPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.DualPistolAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FlameThrower;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FlameThrowerAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FrostGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GoldenPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GoldenPistolAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Handgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HandgunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HuntingRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HuntingRifleAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSG;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSGAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Magnum;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagnumAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MarksmanRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MarksmanRifleAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ParalysisGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Pistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PistolAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PlasmaCannon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PlasmaCannonAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Revolver;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RevolverAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SleepGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifleAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SubMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SubMachinegunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WA2000;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WA2000AP;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;

public class StableAPBullet
extends InventorySpell {
    private static final ItemSprite.Glowing WHITE = new ItemSprite.Glowing(0xFFFFFF);

    public StableAPBullet() {
        this.image = ItemSpriteSheet.AP_BULLET;
        this.unique = true;
        this.bones = false;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return WHITE;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return item instanceof CrudePistol || item instanceof Pistol || item instanceof GoldenPistol || item instanceof Handgun || item instanceof Magnum || item instanceof TacticalHandgun || item instanceof AutoHandgun || item instanceof DualPistol || item instanceof SubMachinegun || item instanceof AssultRifle || item instanceof HeavyMachinegun || item instanceof MiniGun || item instanceof AutoRifle || item instanceof Revolver || item instanceof HuntingRifle || item instanceof Carbine || item instanceof SniperRifle || item instanceof AntimaterRifle || item instanceof MarksmanRifle || item instanceof WA2000 || item instanceof ShotGun || item instanceof KSG || item instanceof FlameThrower || item instanceof PlasmaCannon || item instanceof GrenadeLauncher || item instanceof GrenadeLauncherHP || item instanceof SleepGun || item instanceof ParalysisGun || item instanceof StunGun || item instanceof StunGunHP;
    }

    @Override
    protected void onItemSelected(Item item) {
        Item result = StableAPBullet.changeItem(item);
        if (result == null) {
            GLog.n(Messages.get(this, "nothing", new Object[0]), new Object[0]);
            curItem.collect(StableAPBullet.curUser.belongings.backpack);
        } else {
            if (item.isEquipped(Dungeon.hero)) {
                item.cursed = false;
                ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                ((EquipableItem)result).doEquip(Dungeon.hero);
            } else {
                item.detach(Dungeon.hero.belongings.backpack);
                if (!result.collect()) {
                    Dungeon.level.drop((Item)result, (int)StableAPBullet.curUser.pos).sprite.drop();
                }
            }
            if (result.isIdentified()) {
                Catalog.setSeen(result.getClass());
            }
            Dungeon.hero.sprite.emitter().start(Speck.factory(4), 0.2f, 3);
            GLog.p(Messages.get(this, "load", new Object[0]), new Object[0]);
        }
    }

    public static Item changeItem(Item item) {
        if (item instanceof MeleeWeapon) {
            return StableAPBullet.changeWeapon((Weapon)item);
        }
        if (item instanceof StunGun || item instanceof StunGunHP) {
            return new StunGunAP();
        }
        return null;
    }

    private static Weapon changeWeapon(Weapon w) {
        MeleeWeapon n = w instanceof CrudePistol ? new CrudePistolAP() : (w instanceof Pistol ? new PistolAP() : (w instanceof GoldenPistol ? new GoldenPistolAP() : (w instanceof Handgun ? new HandgunAP() : (w instanceof Magnum ? new MagnumAP() : (w instanceof TacticalHandgun ? new TacticalHandgunAP() : (w instanceof AutoHandgun ? new AutoHandgunAP() : (w instanceof DualPistol ? new DualPistolAP() : (w instanceof SubMachinegun ? new SubMachinegunAP() : (w instanceof AssultRifle ? new AssultRifleAP() : (w instanceof HeavyMachinegun ? new HeavyMachinegunAP() : (w instanceof MiniGun ? new MiniGunAP() : (w instanceof AutoRifle ? new AutoRifleAP() : (w instanceof Revolver ? new RevolverAP() : (w instanceof HuntingRifle ? new HuntingRifleAP() : (w instanceof Carbine ? new CarbineAP() : (w instanceof SniperRifle ? new SniperRifleAP() : (w instanceof AntimaterRifle ? new AntimaterRifleAP() : (w instanceof MarksmanRifle ? new MarksmanRifleAP() : (w instanceof WA2000 ? new WA2000AP() : (w instanceof ShotGun ? new ShotGunAP() : (w instanceof KSG ? new KSGAP() : (w instanceof FlameThrower ? new FlameThrowerAP() : (w instanceof PlasmaCannon ? new PlasmaCannonAP() : (w instanceof GrenadeLauncher || w instanceof GrenadeLauncherHP ? new GrenadeLauncherAP() : new FrostGun()))))))))))))))))))))))));
        int level = w.level();
        if (w.curseInfusionBonus) {
            level -= 1 + level / 6;
        }
        if (level > 0) {
            n.upgrade(level);
        } else if (level < 0) {
            n.degrade(-level);
        }
        n.enchantment = w.enchantment;
        n.curseInfusionBonus = w.curseInfusionBonus;
        n.masteryPotionBonus = w.masteryPotionBonus;
        n.levelKnown = w.levelKnown;
        n.cursedKnown = w.cursedKnown;
        n.cursed = w.cursed;
        n.augment = w.augment;
        n.isUpgraded = w.isUpgraded;
        return n;
    }

    @Override
    public int value() {
        return this.quantity * 190;
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{APBullet.class, Evolution.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 15;
            this.output = StableAPBullet.class;
            this.outQuantity = 1;
        }
    }
}

