/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ScrollOfAlchemy;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FrostGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ParalysisGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SleepGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;

public class ScrollOfExtract
extends InventorySpell {
    public ScrollOfExtract() {
        this.image = ItemSpriteSheet.EXOTIC_PLUS;
        this.icon = ItemSpriteSheet.Icons.POTION_MASTERY;
        this.unique = true;
        this.bones = false;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        if (item instanceof MeleeWeapon) {
            return !((MeleeWeapon)item).hasCurseEnchant() && !((MeleeWeapon)item).isUpgraded && item.isIdentified() && !this.cursed && item.buffedLvl() > 0 && !(item instanceof SleepGun) && !(item instanceof FrostGun) && !(item instanceof ParalysisGun) && !(item instanceof GrenadeLauncher) && !(item instanceof GrenadeLauncherAP) && !(item instanceof GrenadeLauncherHP) && !(item instanceof MagesStaff);
        }
        if (item instanceof MissileWeapon) {
            return this.buffedLvl() > 0;
        }
        return false;
    }

    @Override
    protected void onItemSelected(Item item) {
        Item result = ScrollOfExtract.changeItem(item);
        item.level(0);
        if (result == null) {
            GLog.n(Messages.get(this, "nothing", new Object[0]), new Object[0]);
            curItem.collect(ScrollOfExtract.curUser.belongings.backpack);
        } else {
            if (!result.collect()) {
                Dungeon.level.drop((Item)result, (int)ScrollOfExtract.curUser.pos).sprite.drop();
            }
            if (result.isIdentified()) {
                Catalog.setSeen(result.getClass());
            }
            Dungeon.hero.sprite.emitter().start(Speck.factory(4), 0.2f, 3);
            GLog.p(Messages.get(this, "extract", new Object[0]), new Object[0]);
        }
    }

    public static Item changeItem(Item item) {
        if (item instanceof MeleeWeapon || item instanceof MissileWeapon) {
            return ScrollOfExtract.extractWeapon((Weapon)item);
        }
        return null;
    }

    private static Item extractWeapon(Weapon w) {
        int level = Math.min(w.level(), 3);
        Item n = new ScrollOfAlchemy().quantity(level);
        return n;
    }

    @Override
    public int value() {
        return this.quantity * 300;
    }
}

