/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.GunEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.WeaponEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Cartridge;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.Spell;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import java.text.DecimalFormat;

public class MagicalBullet
extends Spell {
    public MagicalBullet() {
        this.image = ItemSpriteSheet.MAGICAL_BULLET;
    }

    @Override
    protected void onCast(Hero hero) {
        if (hero.heroClass == HeroClass.GUNNER) {
            GunEmpower buff = hero.buff(GunEmpower.class);
            if (buff != null) {
                Buff.affect(hero, GunEmpower.class).levelUp();
            } else {
                Buff.affect(hero, GunEmpower.class).reset(1, GunEmpower.DURATION);
            }
        } else {
            Buff.affect(hero, WeaponEmpower.class).set(1, 30.0f);
        }
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/evoke.mp3");
        CellEmitter.center(hero.pos).burst(Speck.factory(1), 7);
        if (hero.heroClass == HeroClass.GUNNER) {
            GLog.p(Messages.get(this, "empower", new Object[0]), new Object[0]);
        } else {
            GLog.p(Messages.get(this, "empower_else", new Object[0]), new Object[0]);
        }
        this.detach(MagicalBullet.curUser.belongings.backpack);
        MagicalBullet.updateQuickslot();
        hero.spendAndNext(1.0f);
    }

    @Override
    public String info() {
        String info = this.desc();
        info = Dungeon.hero.heroClass == HeroClass.GUNNER ? info + "\n\n" + Messages.get(this, "desc_gunner", new DecimalFormat("#").format(Math.ceil((float)Dungeon.hero.lvl / 5.0f))) : info + "\n\n" + Messages.get(this, "desc_else", new Object[0]);
        return info;
    }

    @Override
    public int value() {
        return Math.round(this.quantity * 25);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ArcaneCatalyst.class, Cartridge.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 2;
            this.output = MagicalBullet.class;
            this.outQuantity = 1;
        }
    }
}

