/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Splash;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfStormClouds;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.TargetedSpell;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.utils.PathFinder;

public class HandyBarricade
extends TargetedSpell {
    public HandyBarricade() {
        this.image = ItemSpriteSheet.HANDY_BARRICADE;
    }

    @Override
    protected void affectTarget(Ballistica bolt, Hero hero) {
        int cell = bolt.collisionPos;
        Splash.at(cell, 10063708, 10);
        for (int i : PathFinder.NEIGHBOURS9) {
            Char ch = Actor.findChar(cell + i);
            if (Dungeon.level.map[cell + i] != 1 && Dungeon.level.map[cell + i] != 29 && Dungeon.level.map[cell + i] != 2 && Dungeon.level.map[cell + i] != 15 && Dungeon.level.map[cell + i] != 9 || ch != null) continue;
            Level.set(cell + i, 13);
            GameScene.updateMap(cell + i);
        }
    }

    @Override
    public int value() {
        return Math.round((float)this.quantity * 8.333333f);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{PotionOfStormClouds.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 2;
            this.output = HandyBarricade.class;
            this.outQuantity = 12;
        }
    }
}

