/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FireImbue;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.FlameParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs.ElixirOfDragonsBlood;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.Embers;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.Spell;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;

public class FireImbueSpell
extends Spell {
    public FireImbueSpell() {
        this.image = ItemSpriteSheet.FIREIMBUE_SPELL;
        this.unique = true;
        this.bones = false;
    }

    @Override
    protected void onCast(Hero hero) {
        if (hero.buff(ImbueCooldown.class) == null) {
            if (Dungeon.isChallenged(2048)) {
                Buff.affect(hero, FireImbue.class).set(5.0f);
            } else {
                Buff.affect(hero, FireImbue.class).set(10.0f);
            }
            Buff.affect(hero, ImbueCooldown.class, 200.0f);
            hero.sprite.operate(hero.pos);
            Sample.INSTANCE.play("sounds/burning.mp3");
            hero.sprite.emitter().burst(FlameParticle.FACTORY, 10);
            GLog.p(Messages.get(this, "imbue", new Object[0]), new Object[0]);
            FireImbueSpell.updateQuickslot();
            hero.spendAndNext(1.0f);
        } else {
            GLog.w(Messages.get(this, "cooldown", new Object[0]), new Object[0]);
        }
    }

    @Override
    public int value() {
        return 0;
    }

    public static class ImbueCooldown
    extends FlavourBuff {
        public static final float DURATION = 200.0f;

        public ImbueCooldown() {
            this.type = Buff.buffType.NEUTRAL;
            this.announced = false;
        }

        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0xFF0000);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (200.0f - this.visualcooldown()) / 200.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns());
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ElixirOfDragonsBlood.class, ArcaneCatalyst.class, Embers.class};
            this.inQuantity = new int[]{1, 1, 1};
            this.cost = 10;
            this.output = FireImbueSpell.class;
            this.outQuantity = 1;
        }
    }
}

