/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Challenges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.Transmuting;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTransmutation;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FrostGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ParalysisGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SleepGun;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;

public class Evolution
extends InventorySpell {
    public Evolution() {
        this.image = ItemSpriteSheet.EVOLUTION;
        this.unique = true;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        KindOfWeapon second = null;
        if (Dungeon.hero.belongings.secondWep != null) {
            second = Dungeon.hero.belongings.secondWep;
        }
        if (Dungeon.hero.subClass == HeroSubClass.WIZARD && second != null && item == second) {
            return false;
        }
        return item instanceof MeleeWeapon && !(item instanceof GrenadeLauncher) && !(item instanceof GrenadeLauncherAP) && !(item instanceof GrenadeLauncherHP) && !(item instanceof SleepGun) && !(item instanceof FrostGun) && !(item instanceof ParalysisGun);
    }

    @Override
    protected void onItemSelected(Item item) {
        Item result = Evolution.changeItem(item);
        if (result == null) {
            GLog.n(Messages.get(this, "nothing", new Object[0]), new Object[0]);
            curItem.collect(Evolution.curUser.belongings.backpack);
        } else {
            if (result != item) {
                int slot = Dungeon.quickslot.getSlot(item);
                if (item.isEquipped(Dungeon.hero)) {
                    item.cursed = false;
                    if (item instanceof Artifact && result instanceof Ring) {
                        ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                        if (!result.collect()) {
                            Dungeon.level.drop((Item)result, (int)Evolution.curUser.pos).sprite.drop();
                        }
                    } else if (item instanceof KindOfWeapon && Dungeon.hero.belongings.secondWep() == item) {
                        ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                        ((KindOfWeapon)result).equipSecondary(Dungeon.hero);
                    } else {
                        ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                        ((EquipableItem)result).doEquip(Dungeon.hero);
                    }
                    Dungeon.hero.spend(-Dungeon.hero.cooldown());
                } else {
                    item.detach(Dungeon.hero.belongings.backpack);
                    if (!result.collect()) {
                        Dungeon.level.drop((Item)result, (int)Evolution.curUser.pos).sprite.drop();
                    } else if (Dungeon.hero.belongings.getSimilar(result) != null) {
                        result = Dungeon.hero.belongings.getSimilar(result);
                    }
                }
                if (slot != -1 && result.defaultAction() != null && !Dungeon.quickslot.isNonePlaceholder(slot).booleanValue() && Dungeon.hero.belongings.contains(result)) {
                    Dungeon.quickslot.setSlot(slot, result);
                }
            }
            if (result.isIdentified()) {
                Catalog.setSeen(result.getClass());
            }
            Transmuting.show((Char)curUser, item, result);
            Evolution.curUser.sprite.emitter().start(Speck.factory(10), 0.2f, 10);
            GLog.p(Messages.get(this, "evolve", new Object[0]), new Object[0]);
        }
    }

    public static Item changeItem(Item item) {
        if (item instanceof MeleeWeapon) {
            return Evolution.changeWeapon((Weapon)item);
        }
        return null;
    }

    private static Weapon changeWeapon(Weapon w) {
        Weapon n;
        Generator.Category c = ((MeleeWeapon)w).tier == 7 ? (Dungeon.hero.hasTalent(Talent.TRANSMUTATION_CONTROL) ? Generator.gunTiers[((MeleeWeapon)w).tier - 3] : Generator.wepTiers[((MeleeWeapon)w).tier - 3]) : (((MeleeWeapon)w).tier == 6 ? (Dungeon.hero.hasTalent(Talent.TRANSMUTATION_CONTROL) ? Generator.gunTiers[((MeleeWeapon)w).tier - 2] : Generator.wepTiers[((MeleeWeapon)w).tier - 2]) : (((MeleeWeapon)w).tier == 5 ? (Dungeon.hero.hasTalent(Talent.TRANSMUTATION_CONTROL) ? Generator.gunTiers[((MeleeWeapon)w).tier - 1] : Generator.wepTiers[((MeleeWeapon)w).tier - 1]) : (Dungeon.hero.hasTalent(Talent.TRANSMUTATION_CONTROL) ? Generator.gunTiers[((MeleeWeapon)w).tier] : Generator.wepTiers[((MeleeWeapon)w).tier])));
        while (Challenges.isItemBlocked(n = (Weapon)Reflection.newInstance(c.classes[Random.chances(c.probs)])) || n.getClass() == w.getClass()) {
        }
        n.level(0);
        n.quantity(1);
        int level = w.trueLevel();
        if (level > 0) {
            n.upgrade(level);
        } else if (level < 0) {
            n.degrade(-level);
        }
        n.enchantment = w.enchantment;
        n.curseInfusionBonus = w.curseInfusionBonus;
        n.masteryPotionBonus = w.masteryPotionBonus;
        n.levelKnown = w.levelKnown;
        n.cursedKnown = w.cursedKnown;
        n.cursed = w.cursed;
        n.augment = w.augment;
        n.isUpgraded = w.isUpgraded;
        if (Dungeon.isChallenged(8192)) {
            n.fix();
        }
        return n;
    }

    @Override
    public int value() {
        return Math.round(this.quantity * 90);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ScrollOfTransmutation.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 3;
            this.output = Evolution.class;
            this.outQuantity = 1;
        }
    }
}

