/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.Transmuting;
import com.shatteredpixel.shatteredpixeldungeon.items.ArcaneResin;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KindOfWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.Evolution;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifleAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifleHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssassinsBlade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.BeamSaber;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ChainWhip;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Crossbow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ExplosiveCrossbow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gauntlet;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GildedShovel;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Glaive;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Greataxe;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Greatshield;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HugeSword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.IronHammer;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSG;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSGAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSGHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Lance;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.LargeKatana;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Magnum;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagnumAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagnumHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ObsidianShield;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RPG7;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RocketLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RunicBlade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SharpKatana;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Shovel;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifleAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifleHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Spade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TrueRunicBlade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.UnformedBlade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WarHammer;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Random;

public class AdvancedEvolution
extends InventorySpell {
    private static final ItemSprite.Glowing WHITE = new ItemSprite.Glowing(0xFFFFFF);

    public AdvancedEvolution() {
        this.image = ItemSpriteSheet.AD_EVOLUTION;
        this.unique = true;
        this.bones = false;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return WHITE;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        KindOfWeapon second = null;
        if (Dungeon.hero.belongings.secondWep != null) {
            second = Dungeon.hero.belongings.secondWep;
        }
        if (Dungeon.hero.subClass == HeroSubClass.WIZARD && second != null && item == second) {
            return false;
        }
        return !(item instanceof Spade) && item instanceof Weapon && ((Weapon)item).canAdvance;
    }

    @Override
    protected void onItemSelected(Item item) {
        Item result = AdvancedEvolution.changeItem(item);
        if (result == null) {
            GLog.n(Messages.get(this, "nothing", new Object[0]), new Object[0]);
            curItem.collect(AdvancedEvolution.curUser.belongings.backpack);
        } else {
            if (result != item) {
                int slot = Dungeon.quickslot.getSlot(item);
                if (item.isEquipped(Dungeon.hero)) {
                    item.cursed = false;
                    if (item instanceof Artifact && result instanceof Ring) {
                        ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                        if (!result.collect()) {
                            Dungeon.level.drop((Item)result, (int)AdvancedEvolution.curUser.pos).sprite.drop();
                        }
                    } else if (item instanceof KindOfWeapon && Dungeon.hero.belongings.secondWep() == item) {
                        ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                        ((KindOfWeapon)result).equipSecondary(Dungeon.hero);
                    } else {
                        ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                        ((EquipableItem)result).doEquip(Dungeon.hero);
                    }
                    Dungeon.hero.spend(-Dungeon.hero.cooldown());
                } else {
                    item.detach(Dungeon.hero.belongings.backpack);
                    if (!result.collect()) {
                        Dungeon.level.drop((Item)result, (int)AdvancedEvolution.curUser.pos).sprite.drop();
                    } else if (Dungeon.hero.belongings.getSimilar(result) != null) {
                        result = Dungeon.hero.belongings.getSimilar(result);
                    }
                }
                if (slot != -1 && result.defaultAction() != null && !Dungeon.quickslot.isNonePlaceholder(slot).booleanValue() && Dungeon.hero.belongings.contains(result)) {
                    Dungeon.quickslot.setSlot(slot, result);
                }
            }
            if (result.isIdentified()) {
                Catalog.setSeen(result.getClass());
            }
            Transmuting.show((Char)curUser, item, result);
            AdvancedEvolution.curUser.sprite.emitter().start(Speck.factory(10), 0.2f, 10);
            GLog.p(Messages.get(this, "evolve", new Object[0]), new Object[0]);
        }
    }

    public static Item changeItem(Item item) {
        if (item instanceof MeleeWeapon || item instanceof SpiritBow || item instanceof WindBow || item instanceof NaturesBow || item instanceof GoldenBow || item instanceof CorrosionBow || item instanceof MissileWeapon) {
            return AdvancedEvolution.changeWeapon((Weapon)item);
        }
        return null;
    }

    private static float getGunChance() {
        float gunChance = 0.7f;
        if (Dungeon.hero.heroClass == HeroClass.GUNNER) {
            gunChance = 1.0f;
        }
        return gunChance;
    }

    private static float getWepChance() {
        float wepChance = 0.9f;
        if (Dungeon.hero.heroClass == HeroClass.DUELIST) {
            wepChance = 1.0f;
        }
        return wepChance;
    }

    private static Weapon changeWeapon(Weapon w) {
        Weapon n;
        if (w instanceof SniperRifle) {
            n = w instanceof SniperRifleAP ? (Random.Float() < AdvancedEvolution.getGunChance() ? new AntimaterRifleAP() : Generator.randomWeapon()) : (w instanceof SniperRifleHP ? (Random.Float() < AdvancedEvolution.getGunChance() ? new AntimaterRifleHP() : Generator.randomWeapon()) : (Random.Float() < AdvancedEvolution.getGunChance() ? new AntimaterRifle() : Generator.randomWeapon()));
        } else if (w instanceof HeavyMachinegun) {
            n = w instanceof HeavyMachinegunAP ? (Random.Float() < AdvancedEvolution.getGunChance() ? new MiniGunAP() : Generator.randomWeapon()) : (w instanceof HeavyMachinegunHP ? (Random.Float() < AdvancedEvolution.getGunChance() ? new MiniGunHP() : Generator.randomWeapon()) : (Random.Float() < AdvancedEvolution.getGunChance() ? new MiniGun() : Generator.randomWeapon()));
        } else if (w instanceof Magnum) {
            n = w instanceof MagnumAP ? (Random.Float() < AdvancedEvolution.getGunChance() ? new TacticalHandgunAP() : Generator.randomWeapon()) : (w instanceof MagnumHP ? (Random.Float() < AdvancedEvolution.getGunChance() ? new TacticalHandgunHP() : Generator.randomWeapon()) : (Random.Float() < AdvancedEvolution.getGunChance() ? new TacticalHandgun() : Generator.randomWeapon()));
        } else if (w instanceof ShotGun) {
            n = w instanceof ShotGunAP ? (Random.Float() < AdvancedEvolution.getGunChance() ? new KSGAP() : Generator.randomWeapon()) : (w instanceof ShotGunHP ? (Random.Float() < AdvancedEvolution.getGunChance() ? new KSGHP() : Generator.randomWeapon()) : (Random.Float() < AdvancedEvolution.getGunChance() ? new KSG() : Generator.randomWeapon()));
        } else if (w instanceof RocketLauncher) {
            n = Random.Float() < AdvancedEvolution.getGunChance() ? new RPG7() : Generator.randomWeapon();
        } else if (w instanceof LargeKatana) {
            n = Random.Float() < AdvancedEvolution.getWepChance() ? new SharpKatana() : Generator.randomWeapon();
        } else if (w instanceof Glaive) {
            n = Random.Float() < AdvancedEvolution.getWepChance() ? new Lance() : Generator.randomWeapon();
        } else if (w instanceof Greatshield) {
            n = Random.Float() < AdvancedEvolution.getWepChance() ? new ObsidianShield() : Generator.randomWeapon();
        } else if (w instanceof RunicBlade) {
            n = Random.Float() < AdvancedEvolution.getWepChance() ? new TrueRunicBlade() : Generator.randomWeapon();
        } else if (w instanceof AssassinsBlade) {
            n = Random.Float() < AdvancedEvolution.getWepChance() ? new UnformedBlade() : Generator.randomWeapon();
        } else if (w instanceof GildedShovel) {
            n = new Spade();
        } else if (w instanceof Shovel) {
            n = new GildedShovel();
        } else if (w instanceof Greataxe) {
            n = Random.Float() < AdvancedEvolution.getWepChance() ? new HugeSword() : Generator.randomWeapon();
        } else if (w instanceof WarHammer) {
            n = Random.Float() < AdvancedEvolution.getWepChance() ? new IronHammer() : Generator.randomWeapon();
        } else if (w instanceof Gauntlet) {
            n = Random.Float() < AdvancedEvolution.getWepChance() ? new BeamSaber() : Generator.randomWeapon();
        } else if (w instanceof SpiritBow) {
            switch (Random.Int(4)) {
                default: {
                    n = new WindBow();
                    break;
                }
                case 1: {
                    n = new NaturesBow();
                    break;
                }
                case 2: {
                    n = new CorrosionBow();
                    break;
                }
                case 3: {
                    n = new GoldenBow();
                    break;
                }
            }
        } else if (w instanceof WindBow) {
            switch (Random.Int(3)) {
                default: {
                    n = new NaturesBow();
                    break;
                }
                case 1: {
                    n = new CorrosionBow();
                    break;
                }
                case 2: {
                    n = new GoldenBow();
                    break;
                }
            }
        } else if (w instanceof NaturesBow) {
            switch (Random.Int(3)) {
                default: {
                    n = new WindBow();
                    break;
                }
                case 1: {
                    n = new CorrosionBow();
                    break;
                }
                case 2: {
                    n = new GoldenBow();
                    break;
                }
            }
        } else if (w instanceof CorrosionBow) {
            switch (Random.Int(3)) {
                default: {
                    n = new WindBow();
                    break;
                }
                case 1: {
                    n = new NaturesBow();
                    break;
                }
                case 2: {
                    n = new GoldenBow();
                    break;
                }
            }
        } else if (w instanceof GoldenBow) {
            switch (Random.Int(3)) {
                default: {
                    n = new WindBow();
                    break;
                }
                case 1: {
                    n = new NaturesBow();
                    break;
                }
                case 2: {
                    n = new CorrosionBow();
                    break;
                }
            }
        } else {
            n = w instanceof Crossbow ? (Random.Float() < AdvancedEvolution.getWepChance() ? new ExplosiveCrossbow() : Generator.randomWeapon()) : (Random.Float() < AdvancedEvolution.getWepChance() ? new ChainWhip() : Generator.randomWeapon());
        }
        n.level(0);
        n.quantity(1);
        int level = w.trueLevel();
        if (level > 0) {
            n.upgrade(level);
        } else if (level < 0) {
            n.degrade(-level);
        }
        n.enchantment = w.enchantment;
        n.curseInfusionBonus = w.curseInfusionBonus;
        n.masteryPotionBonus = w.masteryPotionBonus;
        n.levelKnown = w.levelKnown;
        n.cursedKnown = w.cursedKnown;
        n.cursed = w.cursed;
        n.augment = w.augment;
        n.isUpgraded = w.isUpgraded;
        if (Dungeon.isChallenged(8192)) {
            n.fix();
        }
        return n;
    }

    @Override
    public String desc() {
        return super.desc() + "\n\n" + Messages.get(this, "chance", Messages.decimalFormat("#", 100.0f * AdvancedEvolution.getGunChance()), Messages.decimalFormat("#", 100.0f * AdvancedEvolution.getWepChance()));
    }

    @Override
    public int value() {
        return Math.round(this.quantity * 190);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Evolution.class, ArcaneCatalyst.class, ArcaneResin.class};
            this.inQuantity = new int[]{1, 1, 2};
            this.cost = 5;
            this.output = AdvancedEvolution.class;
            this.outQuantity = 1;
        }
    }
}

