/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.scrolls;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Degrade;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.InventoryScroll;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Random;

public class ScrollOfUpgrade
extends InventoryScroll {
    public ScrollOfUpgrade() {
        this.icon = ItemSpriteSheet.Icons.SCROLL_UPGRADE;
        this.preferredBag = Belongings.Backpack.class;
        this.unique = true;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return item.isUpgradable();
    }

    @Override
    protected void onItemSelected(Item item) {
        ScrollOfUpgrade.upgrade(curUser);
        Degrade.detach(curUser, Degrade.class);
        if (item instanceof Weapon) {
            Weapon w = (Weapon)item;
            boolean wasCursed = w.cursed;
            boolean hadCursedEnchant = w.hasCurseEnchant();
            boolean hadGoodEnchant = w.hasGoodEnchant();
            w.isUpgraded = true;
            if (w.enchantment != null && Random.Int(2) < Dungeon.hero.pointsInTalent(Talent.MAGICAL_TRANSFERENCE)) {
                if (Dungeon.isChallenged(8192)) {
                    if (w.durability() <= 0) {
                        w.fix();
                    } else {
                        w.upgrade(true);
                    }
                } else {
                    w.upgrade(true);
                }
            } else if (Dungeon.isChallenged(8192)) {
                if (w.durability() <= 0) {
                    w.fix();
                } else {
                    w.upgrade();
                }
            } else {
                w.upgrade();
            }
            if (w.cursedKnown && hadCursedEnchant && !w.hasCurseEnchant()) {
                ScrollOfUpgrade.removeCurse(Dungeon.hero);
            } else if (w.cursedKnown && wasCursed && !w.cursed) {
                ScrollOfUpgrade.weakenCurse(Dungeon.hero);
            }
            if (hadGoodEnchant && !w.hasGoodEnchant()) {
                GLog.w(Messages.get(Weapon.class, "incompatible", new Object[0]), new Object[0]);
            }
        } else if (item instanceof Armor) {
            Armor a = (Armor)item;
            boolean wasCursed = a.cursed;
            boolean hadCursedGlyph = a.hasCurseGlyph();
            boolean hadGoodGlyph = a.hasGoodGlyph();
            if (Dungeon.isChallenged(8192)) {
                if (a.durability() <= 0) {
                    a.fix();
                } else {
                    a.upgrade();
                }
            } else {
                a.upgrade();
            }
            if (a.cursedKnown && hadCursedGlyph && !a.hasCurseGlyph()) {
                ScrollOfUpgrade.removeCurse(Dungeon.hero);
            } else if (a.cursedKnown && wasCursed && !a.cursed) {
                ScrollOfUpgrade.weakenCurse(Dungeon.hero);
            }
            if (hadGoodGlyph && !a.hasGoodGlyph()) {
                GLog.w(Messages.get(Armor.class, "incompatible", new Object[0]), new Object[0]);
            }
        } else if (item instanceof Wand || item instanceof Ring) {
            boolean wasCursed = item.cursed;
            if (Dungeon.isChallenged(8192)) {
                if (item.durability() <= 0) {
                    item.fix();
                } else {
                    item.upgrade();
                }
            } else {
                item.upgrade();
            }
            if (item.cursedKnown && wasCursed && !item.cursed) {
                ScrollOfUpgrade.removeCurse(Dungeon.hero);
            }
        } else if (Dungeon.isChallenged(8192)) {
            if (item.durability() <= 0) {
                item.fix();
            } else {
                item.upgrade();
            }
        } else {
            item.upgrade();
        }
        Talent.onUpgradeScrollUsed(Dungeon.hero);
        Badges.validateItemLevelAquired(item);
        ++Statistics.upgradesUsed;
        Badges.validateMageUnlock();
    }

    public static void upgrade(Hero hero) {
        hero.sprite.emitter().start(Speck.factory(4), 0.2f, 3);
    }

    public static void weakenCurse(Hero hero) {
        GLog.p(Messages.get(ScrollOfUpgrade.class, "weaken_curse", new Object[0]), new Object[0]);
        hero.sprite.emitter().start(ShadowParticle.UP, 0.05f, 5);
    }

    public static void removeCurse(Hero hero) {
        GLog.p(Messages.get(ScrollOfUpgrade.class, "remove_curse", new Object[0]), new Object[0]);
        hero.sprite.emitter().start(ShadowParticle.UP, 0.05f, 10);
    }

    @Override
    public int value() {
        return this.isKnown() ? 50 * this.quantity : super.value();
    }

    @Override
    public int energyVal() {
        return this.isKnown() ? 8 * this.quantity : super.energyVal();
    }
}

