/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.AlchemicalCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfStrength;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs.Elixir;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs.ElixirOfHealth;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.StatusPane;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndHero;
import com.watabou.noosa.audio.Sample;

public class ElixirOfTalent
extends Elixir {
    public ElixirOfTalent() {
        this.image = ItemSpriteSheet.ELIXIR_TALENT;
    }

    @Override
    public void apply(Hero hero) {
        if (hero.buff(BonusTalentTracker.class) == null && hero.subClass != HeroSubClass.NONE && hero.lvl >= 20 && hero.armorAbility == null) {
            hero.STR -= 2;
            hero.onSTRLost();
            Buff.affect(hero, BonusTalentTracker.class);
            Sample.INSTANCE.playDelayed("sounds/levelup.mp3", 0.2f, 0.7f, 1.2f);
            Sample.INSTANCE.playDelayed("sounds/levelup.mp3", 0.4f, 0.7f, 1.2f);
            Sample.INSTANCE.playDelayed("sounds/levelup.mp3", 0.6f, 0.7f, 1.2f);
            Sample.INSTANCE.playDelayed("sounds/levelup.mp3", 0.8f, 0.7f, 1.2f);
            hero.sprite.showStatus(0xFF0000, Messages.get(this, "str_decrease", new Object[0]), new Object[0]);
            GLog.p(Messages.get(this, "bonus", new Object[0]), new Object[0]);
            GameScene.showlevelUpStars();
        } else {
            hero.STR += 2;
            hero.onSTRGained();
            if (Dungeon.isChallenged(1024) || hero.buff(ElixirOfTalentHTBoost.class) != null) {
                hero.sprite.showStatus(65280, Messages.get(this, "str", new Object[0]), new Object[0]);
            } else {
                Buff.affect(hero, ElixirOfTalentHTBoost.class);
                hero.sprite.showStatus(65280, Messages.get(this, "str_ht", new Object[0]), new Object[0]);
            }
            hero.updateHT(true);
            GLog.p(Messages.get(this, "msg_2", new Object[0]), new Object[0]);
        }
        Badges.validateStrengthAttained();
        boolean unspentTalents = false;
        for (int i = 1; i <= Dungeon.hero.talents.size(); ++i) {
            if (Dungeon.hero.talentPointsAvailable(i) <= 0) continue;
            unspentTalents = true;
            break;
        }
        if (unspentTalents) {
            StatusPane.talentBlink = 10.0f;
            WndHero.lastIdx = 1;
        }
        Sample.INSTANCE.play("sounds/drink.mp3");
    }

    @Override
    protected int splashColor() {
        return -132559;
    }

    @Override
    public int value() {
        return this.quantity * 160;
    }

    public static class BonusTalentTracker
    extends Buff {
        public BonusTalentTracker() {
            this.type = Buff.buffType.POSITIVE;
            this.revivePersists = true;
        }
    }

    public static class ElixirOfTalentHTBoost
    extends Buff {
        public ElixirOfTalentHTBoost() {
            this.type = Buff.buffType.POSITIVE;
        }

        public int boost() {
            return Math.round((float)(20 + 5 * (((Hero)this.target).lvl - 1)) / 10.0f);
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{PotionOfStrength.class, ElixirOfHealth.class, AlchemicalCatalyst.class};
            this.inQuantity = new int[]{1, 1, 1};
            this.cost = 8;
            this.output = ElixirOfTalent.class;
            this.outQuantity = 1;
        }
    }
}

