/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Hunger;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.food.Pasty;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.AlchemicalCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfStrength;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs.Elixir;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;

public class ElixirOfHealth
extends Elixir {
    public ElixirOfHealth() {
        this.image = ItemSpriteSheet.ELIXIR_HEALTH;
    }

    @Override
    public void apply(Hero hero) {
        if (Dungeon.isChallenged(1024) || hero.buff(ElixirOfHealthHTBoost.class) != null) {
            ++hero.STR;
            hero.onSTRGained();
            Buff.affect(hero, Hunger.class).satisfy(450.0f);
            Talent.onFoodEaten(hero, 450.0f, this);
            GLog.p(Messages.get(this, "food", new Object[0]), new Object[0]);
            hero.sprite.showStatus(65280, Messages.get(PotionOfStrength.class, "msg_1", new Object[0]), new Object[0]);
        } else {
            hero.sprite.showStatus(65280, Messages.get(this, "max_health", new Object[0]), new Object[0]);
            Buff.affect(hero, ElixirOfHealthHTBoost.class);
            hero.updateHT(true);
            Sample.INSTANCE.play("sounds/drink.mp3");
            hero.sprite.emitter().burst(Speck.factory(0), 2);
        }
    }

    @Override
    protected int splashColor() {
        return -65494;
    }

    @Override
    public int value() {
        return this.quantity * 110;
    }

    public static class ElixirOfHealthHTBoost
    extends Buff {
        public ElixirOfHealthHTBoost() {
            this.type = Buff.buffType.POSITIVE;
        }

        public int boost() {
            return Math.round((float)(20 + 5 * (((Hero)this.target).lvl - 1)) / 20.0f);
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{PotionOfStrength.class, AlchemicalCatalyst.class, Pasty.class};
            this.inQuantity = new int[]{1, 1, 1};
            this.cost = 8;
            this.output = ElixirOfHealth.class;
            this.outQuantity = 1;
        }
    }
}

