/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.potions;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArmorEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.AlchemicalCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;

public class PotionOfArmorEnhance
extends Potion {
    public PotionOfArmorEnhance() {
        this.icon = ItemSpriteSheet.Icons.POTION_ARMOR;
    }

    @Override
    public void apply(Hero hero) {
        this.identify();
        Buff.affect(hero, ArmorEmpower.class).set((int)Math.ceil((float)hero.lvl / 5.0f), 20.0f);
        GLog.p(Messages.get(this, "empower", new Object[0]), new Object[0]);
        Sample.INSTANCE.play("sounds/evoke.mp3");
        CellEmitter.center(hero.pos).burst(Speck.factory(1), 7);
        PotionOfArmorEnhance.updateQuickslot();
    }

    @Override
    public int value() {
        return this.isKnown() ? 50 * this.quantity : super.value();
    }

    @Override
    public int energyVal() {
        return this.isKnown() ? 8 * this.quantity : super.energyVal();
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ScrollOfUpgrade.class, AlchemicalCatalyst.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 4;
            this.output = PotionOfArmorEnhance.class;
            this.outQuantity = 2;
        }
    }
}

