/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.bombs;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.GooWarn;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ElmoParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.bombs.Bomb;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class ArcaneBomb
extends Bomb.MagicalBomb {
    public ArcaneBomb() {
        this.image = ItemSpriteSheet.ARCANE_BOMB;
    }

    @Override
    protected void onThrow(int cell) {
        super.onThrow(cell);
        if (this.fuse != null) {
            PathFinder.buildDistanceMap(cell, BArray.not(Dungeon.level.solid, null), 2);
            for (int i = 0; i < PathFinder.distance.length; ++i) {
                if (PathFinder.distance[i] >= Integer.MAX_VALUE) continue;
                GameScene.add(Blob.seed(i, 3, GooWarn.class));
            }
        }
    }

    @Override
    public boolean explodesDestructively() {
        return false;
    }

    @Override
    public void explode(int cell) {
        super.explode(cell);
        ArrayList<Char> affected = new ArrayList<Char>();
        PathFinder.buildDistanceMap(cell, BArray.not(Dungeon.level.solid, null), 2);
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            Char ch;
            if (PathFinder.distance[i] >= Integer.MAX_VALUE) continue;
            if (Dungeon.level.heroFOV[i]) {
                CellEmitter.get(i).burst(ElmoParticle.FACTORY, 10);
            }
            if ((ch = Actor.findChar(i)) == null) continue;
            affected.add(ch);
        }
        for (Char ch : affected) {
            int damage = Math.round(Random.NormalIntRange(Dungeon.scalingDepth() + 5, 10 + Dungeon.scalingDepth() * 2));
            float multiplier = 1.0f - 0.16667f * (float)Dungeon.level.distance(cell, ch.pos);
            ch.damage(Math.round((float)damage * multiplier), this);
            if (ch != Dungeon.hero || ch.isAlive()) continue;
            Badges.validateDeathFromFriendlyMagic();
            Dungeon.fail(this);
        }
    }

    @Override
    public int value() {
        return this.quantity * 50;
    }
}

