/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.artifacts;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.CapeOfThorns;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLivingEarth;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Earthroot;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class ChaliceOfBlood
extends Artifact {
    public static final String AC_PRICK = "PRICK";

    public ChaliceOfBlood() {
        this.image = ItemSpriteSheet.ARTIFACT_CHALICE1;
        this.levelCap = 10;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero) && this.level() < this.levelCap && !this.cursed && !hero.isInvulnerable(this.getClass()) && hero.buff(MagicImmune.class) == null && hero.buff(CapeOfThorns.Thorns.class) == null) {
            actions.add(AC_PRICK);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_PRICK)) {
            int damage = 5 + 3 * (this.level() * this.level());
            if ((double)damage > (double)hero.HP * 0.75) {
                GameScene.show(new WndOptions(new ItemSprite(this), Messages.titleCase(this.name()), Messages.get(this, "prick_warn", new Object[0]), new String[]{Messages.get(this, "yes", new Object[0]), Messages.get(this, "no", new Object[0])}){

                    @Override
                    protected void onSelect(int index) {
                        if (index == 0) {
                            ChaliceOfBlood.this.prick(Dungeon.hero);
                        }
                    }
                });
            } else {
                this.prick(hero);
            }
        }
    }

    private void prick(Hero hero) {
        WandOfLivingEarth.RockArmor rockArmor;
        int damage = 5 + 3 * (this.level() * this.level());
        Earthroot.Armor armor = hero.buff(Earthroot.Armor.class);
        if (armor != null) {
            damage = armor.absorb(damage);
        }
        if ((rockArmor = hero.buff(WandOfLivingEarth.RockArmor.class)) != null) {
            damage = rockArmor.absorb(damage);
        }
        hero.sprite.operate(hero.pos);
        hero.busy();
        hero.spend(3.0f);
        GLog.w(Messages.get(this, "onprick", new Object[0]), new Object[0]);
        if ((damage -= hero.drRoll()) <= 0) {
            damage = 1;
        } else {
            Sample.INSTANCE.play("sounds/cursed.mp3");
            hero.sprite.emitter().burst(ShadowParticle.CURSE, 4 + damage / 10);
        }
        hero.damage(damage, this);
        if (!hero.isAlive()) {
            Badges.validateDeathFromFriendlyMagic();
            Dungeon.fail(this);
            GLog.n(Messages.get(this, "ondeath", new Object[0]), new Object[0]);
        } else {
            this.upgrade();
        }
    }

    @Override
    public Item upgrade() {
        if (this.level() >= 6) {
            this.image = ItemSpriteSheet.ARTIFACT_CHALICE3;
        } else if (this.level() >= 2) {
            this.image = ItemSpriteSheet.ARTIFACT_CHALICE2;
        }
        return super.upgrade();
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        if (this.level() >= 7) {
            this.image = ItemSpriteSheet.ARTIFACT_CHALICE3;
        } else if (this.level() >= 3) {
            this.image = ItemSpriteSheet.ARTIFACT_CHALICE2;
        }
    }

    @Override
    protected Artifact.ArtifactBuff passiveBuff() {
        return new chaliceRegen();
    }

    @Override
    public void charge(Hero target, float amount) {
        if (this.cursed || target.buff(MagicImmune.class) != null) {
            return;
        }
        if (target.isStarving()) {
            return;
        }
        float healDelay = 10.0f - (1.33f + (float)this.level() * 0.667f);
        float heal = 5.0f / (healDelay /= amount);
        if (Random.Float() < heal % 1.0f) {
            heal += 1.0f;
        }
        if (heal >= 1.0f) {
            target.HP = Math.min(target.HT, target.HP + (int)heal);
        }
    }

    @Override
    public String desc() {
        String desc = super.desc();
        if (this.isEquipped(Dungeon.hero)) {
            desc = desc + "\n\n";
            desc = this.cursed ? desc + Messages.get(this, "desc_cursed", new Object[0]) : (this.level() == 0 ? desc + Messages.get(this, "desc_1", new Object[0]) : (this.level() < this.levelCap ? desc + Messages.get(this, "desc_2", new Object[0]) : desc + Messages.get(this, "desc_3", new Object[0])));
        }
        return desc;
    }

    public class chaliceRegen
    extends Artifact.ArtifactBuff {
    }
}

