/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfMagicMapping;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.FeatherFall;
import com.shatteredpixel.shatteredpixeldungeon.levels.Terrain;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Chasm;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.Game;
import java.util.ArrayList;

public class Teleporter
extends Item {
    String AC_TELEPORT = "teleport";
    String AC_RETURN = "return";

    public Teleporter() {
        this.defaultAction = this.AC_TELEPORT;
        this.image = ItemSpriteSheet.MISSILE_BUTTON;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(this.AC_TELEPORT);
        actions.add(this.AC_RETURN);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        int terr;
        int i;
        boolean[] discoverable;
        boolean[] mapped;
        int[] map;
        int length;
        super.execute(hero, action);
        if (action.equals(this.AC_TELEPORT)) {
            Buff.affect(hero, FeatherFall.FeatherBuff.class, 3.0f);
            Chasm.heroFall(hero.pos);
            length = Dungeon.level.length();
            map = Dungeon.level.map;
            mapped = Dungeon.level.mapped;
            discoverable = Dungeon.level.discoverable;
            for (i = 0; i < length; ++i) {
                terr = map[i];
                if (!discoverable[i]) continue;
                mapped[i] = true;
                if ((Terrain.flags[terr] & 8) == 0) continue;
                Dungeon.level.discover(i);
                if (!Dungeon.level.heroFOV[i]) continue;
                GameScene.discoverTile(i, terr);
                ScrollOfMagicMapping.discover(i);
            }
            GameScene.updateFog();
        }
        if (action.equals(this.AC_RETURN)) {
            InterlevelScene.mode = InterlevelScene.Mode.RETURN;
            InterlevelScene.returnDepth = Math.max(1, Dungeon.depth - 1);
            InterlevelScene.returnBranch = 0;
            InterlevelScene.returnPos = -2;
            Game.switchScene(InterlevelScene.class);
        }
        length = Dungeon.level.length();
        map = Dungeon.level.map;
        mapped = Dungeon.level.mapped;
        discoverable = Dungeon.level.discoverable;
        for (i = 0; i < length; ++i) {
            terr = map[i];
            if (!discoverable[i]) continue;
            mapped[i] = true;
            if ((Terrain.flags[terr] & 8) == 0) continue;
            Dungeon.level.discover(i);
            if (!Dungeon.level.heroFOV[i]) continue;
            GameScene.discoverTile(i, terr);
            ScrollOfMagicMapping.discover(i);
        }
        GameScene.updateFog();
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }
}

