/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.CertainCrit;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.CritBonus;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Demonization;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Flurry;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Iaido;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.IntervalWeaponUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Jung;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SerialAttack;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Sheathing;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.WeaponEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfVorpal;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Disintegration;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public abstract class KindOfWeapon
extends EquipableItem {
    protected static final float TIME_TO_EQUIP = 1.0f;
    protected String hitSound = "sounds/hit.mp3";
    protected float hitSoundPitch = 1.0f;
    public boolean gun = false;
    public boolean handGun = false;
    public boolean machineGun = false;
    public boolean sniperGun = false;
    public boolean shotGun = false;
    public boolean rocketGun = false;
    public boolean heavyGun = false;
    public boolean bullet = false;
    public boolean handGunBullet = false;
    public boolean machineGunBullet = false;
    public boolean sniperGunBullet = false;
    public boolean shotGunBullet = false;
    public boolean rocketGunBullet = false;

    @Override
    public void execute(final Hero hero, String action) {
        if (hero.subClass == HeroSubClass.CHAMPION && action.equals("EQUIP")) {
            this.usesTargeting = false;
            String primaryName = Messages.titleCase(hero.belongings.weapon != null ? hero.belongings.weapon.trueName() : Messages.get(KindOfWeapon.class, "empty", new Object[0]));
            String secondaryName = Messages.titleCase(hero.belongings.secondWep != null ? hero.belongings.secondWep.trueName() : Messages.get(KindOfWeapon.class, "empty", new Object[0]));
            if (primaryName.length() > 18) {
                primaryName = primaryName.substring(0, 15) + "...";
            }
            if (secondaryName.length() > 18) {
                secondaryName = secondaryName.substring(0, 15) + "...";
            }
            GameScene.show(new WndOptions(new ItemSprite(this), Messages.titleCase(this.name()), Messages.get(KindOfWeapon.class, "which_equip_msg", new Object[0]), new String[]{Messages.get(KindOfWeapon.class, "which_equip_primary", primaryName), Messages.get(KindOfWeapon.class, "which_equip_secondary", secondaryName)}){

                @Override
                protected void onSelect(int index) {
                    super.onSelect(index);
                    if (index == 0 || index == 1) {
                        int slot = Dungeon.quickslot.getSlot(KindOfWeapon.this);
                        EquipableItem.slotOfUnequipped = -1;
                        if (index == 0) {
                            KindOfWeapon.this.doEquip(hero);
                        } else {
                            KindOfWeapon.this.equipSecondary(hero);
                        }
                        if (slot != -1) {
                            Dungeon.quickslot.setSlot(slot, KindOfWeapon.this);
                            Item.updateQuickslot();
                        } else if (EquipableItem.slotOfUnequipped != -1 && KindOfWeapon.this.defaultAction() != null) {
                            Dungeon.quickslot.setSlot(EquipableItem.slotOfUnequipped, KindOfWeapon.this);
                            Item.updateQuickslot();
                        }
                    }
                }
            });
        } else if (this instanceof SpellBook && hero.subClass == HeroSubClass.WIZARD && action.equals("EQUIP")) {
            this.usesTargeting = false;
            String primaryName = Messages.titleCase(hero.belongings.weapon != null ? hero.belongings.weapon.trueName() : Messages.get(KindOfWeapon.class, "empty", new Object[0]));
            String secondaryName = Messages.titleCase(hero.belongings.secondWep != null ? hero.belongings.secondWep.trueName() : Messages.get(KindOfWeapon.class, "empty", new Object[0]));
            if (primaryName.length() > 18) {
                primaryName = primaryName.substring(0, 15) + "...";
            }
            if (secondaryName.length() > 18) {
                secondaryName = secondaryName.substring(0, 15) + "...";
            }
            GameScene.show(new WndOptions(new ItemSprite(this), Messages.titleCase(this.name()), Messages.get(KindOfWeapon.class, "which_equip_msg_spellbook", new Object[0]), new String[]{Messages.get(KindOfWeapon.class, "which_equip_primary", primaryName), Messages.get(KindOfWeapon.class, "which_equip_secondary", secondaryName)}){

                @Override
                protected void onSelect(int index) {
                    super.onSelect(index);
                    if (index == 0 || index == 1) {
                        int slot = Dungeon.quickslot.getSlot(KindOfWeapon.this);
                        EquipableItem.slotOfUnequipped = -1;
                        if (index == 0) {
                            KindOfWeapon.this.doEquip(hero);
                        } else {
                            KindOfWeapon.this.equipSecondary(hero);
                        }
                        if (slot != -1) {
                            Dungeon.quickslot.setSlot(slot, KindOfWeapon.this);
                            Item.updateQuickslot();
                        } else if (EquipableItem.slotOfUnequipped != -1 && KindOfWeapon.this.defaultAction() != null) {
                            Dungeon.quickslot.setSlot(EquipableItem.slotOfUnequipped, KindOfWeapon.this);
                            Item.updateQuickslot();
                        }
                    }
                }
            });
        } else {
            super.execute(hero, action);
        }
    }

    @Override
    public boolean isEquipped(Hero hero) {
        return hero.belongings.weapon() == this || hero.belongings.secondWep() == this;
    }

    @Override
    public boolean doEquip(Hero hero) {
        boolean wasInInv = hero.belongings.contains(this);
        this.detachAll(hero.belongings.backpack);
        if (hero.belongings.weapon == null || hero.belongings.weapon.doUnequip(hero, true)) {
            hero.belongings.weapon = this;
            this.activate(hero);
            Talent.onItemEquipped(hero, this);
            Badges.validateDuelistUnlock();
            ActionIndicator.refresh();
            KindOfWeapon.updateQuickslot();
            this.cursedKnown = true;
            if (this.cursed) {
                KindOfWeapon.equipCursed(hero);
                GLog.n(Messages.get(KindOfWeapon.class, "equip_cursed", new Object[0]), new Object[0]);
            }
            if (wasInInv && hero.hasTalent(Talent.SWIFT_EQUIP)) {
                if (hero.buff(Talent.SwiftEquipCooldown.class) == null) {
                    hero.spendAndNext(-hero.cooldown());
                    Buff.affect((Char)hero, Talent.SwiftEquipCooldown.class, (float)19.0f).secondUse = hero.pointsInTalent(Talent.SWIFT_EQUIP) == 2;
                    GLog.i(Messages.get(this, "swift_equip", new Object[0]), new Object[0]);
                } else if (hero.buff(Talent.SwiftEquipCooldown.class).hasSecondUse()) {
                    hero.spendAndNext(-hero.cooldown());
                    hero.buff(Talent.SwiftEquipCooldown.class).secondUse = false;
                    GLog.i(Messages.get(this, "swift_equip", new Object[0]), new Object[0]);
                } else {
                    hero.spendAndNext(1.0f);
                }
            } else if (hero.subClass != HeroSubClass.WEAPONMASTER) {
                if (hero.hasTalent(Talent.QUICK_SWAP) && hero.buff(Talent.QuickSwapCooldown.class) == null) {
                    if (hero.hasTalent(Talent.QUICK_SWAP)) {
                        Buff.affect(hero, WeaponEmpower.class).set(hero.pointsInTalent(Talent.QUICK_SWAP), 1.0f);
                        Buff.affect(hero, Talent.QuickSwapCooldown.class, 5.0f);
                    }
                } else {
                    hero.spendAndNext(1.0f);
                }
            }
            return true;
        }
        this.collect(hero.belongings.backpack);
        return false;
    }

    public boolean equipSecondary(Hero hero) {
        boolean wasInInv = hero.belongings.contains(this);
        this.detachAll(hero.belongings.backpack);
        if (hero.belongings.secondWep == null || hero.belongings.secondWep.doUnequip(hero, true)) {
            hero.belongings.secondWep = this;
            this.activate(hero);
            Talent.onItemEquipped(hero, this);
            Badges.validateDuelistUnlock();
            ActionIndicator.refresh();
            KindOfWeapon.updateQuickslot();
            this.cursedKnown = true;
            if (this.cursed) {
                KindOfWeapon.equipCursed(hero);
                GLog.n(Messages.get(KindOfWeapon.class, "equip_cursed", new Object[0]), new Object[0]);
            }
            if (wasInInv && hero.hasTalent(Talent.SWIFT_EQUIP)) {
                if (hero.buff(Talent.SwiftEquipCooldown.class) == null) {
                    hero.spendAndNext(-hero.cooldown());
                    Buff.affect((Char)hero, Talent.SwiftEquipCooldown.class, (float)19.0f).secondUse = hero.pointsInTalent(Talent.SWIFT_EQUIP) == 2;
                    GLog.i(Messages.get(this, "swift_equip", new Object[0]), new Object[0]);
                } else if (hero.buff(Talent.SwiftEquipCooldown.class).hasSecondUse()) {
                    hero.spendAndNext(-hero.cooldown());
                    hero.buff(Talent.SwiftEquipCooldown.class).secondUse = false;
                    GLog.i(Messages.get(this, "swift_equip", new Object[0]), new Object[0]);
                } else {
                    hero.spendAndNext(1.0f);
                }
            } else {
                hero.spendAndNext(1.0f);
            }
            return true;
        }
        this.collect(hero.belongings.backpack);
        return false;
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        boolean second;
        boolean bl = second = hero.belongings.secondWep == this;
        if (second) {
            hero.belongings.secondWep = null;
        }
        if (super.doUnequip(hero, collect, single)) {
            if (!second) {
                hero.belongings.weapon = null;
            }
            return true;
        }
        if (second) {
            hero.belongings.secondWep = this;
        }
        return false;
    }

    public int min() {
        return this.min(this.buffedLvl());
    }

    public int max() {
        return this.max(this.buffedLvl());
    }

    public int STRReq() {
        return this.STRReq();
    }

    public abstract int min(int var1);

    public abstract int max(int var1);

    public int critChance() {
        int critChance = 0;
        Demonization demonization = Dungeon.hero.buff(Demonization.class);
        if (demonization != null && demonization.isDemonated()) {
            critChance += (Dungeon.hero.defenseSkill(Dungeon.hero) - (Dungeon.hero.lvl + 5)) / 2;
        }
        if (Dungeon.hero.heroClass == HeroClass.SAMURAI && Dungeon.hero.belongings.weapon != null) {
            critChance += 2 * (Dungeon.hero.STR() - Dungeon.hero.belongings.weapon.STRReq());
            critChance += Dungeon.hero.lvl;
        }
        if (Dungeon.hero.buff(Talent.SurpriseStabTracker.class) != null) {
            critChance += 5 * Dungeon.hero.pointsInTalent(Talent.SURPRISE_STAB);
            Dungeon.hero.buff(Talent.SurpriseStabTracker.class).detach();
        }
        if (Dungeon.hero.buff(Sheathing.class) != null) {
            critChance = Dungeon.hero.buff(Iaido.class) != null ? (int)((float)critChance * (1.2f + 0.3f * (float)Dungeon.hero.buff(Iaido.class).getCount())) : (int)((float)critChance * 1.2f);
        }
        if (Dungeon.hero.buff(Jung.class) != null) {
            critChance = (int)((float)critChance * (2.0f + 0.5f * (float)Dungeon.hero.pointsInTalent(Talent.JUNG_DETECTION)));
        }
        if (Dungeon.hero.buff(CritBonus.class) != null) {
            critChance = (int)((float)critChance + Dungeon.hero.buff(CritBonus.class).level());
        }
        if (Dungeon.hero.buff(IntervalWeaponUpgrade.class) != null) {
            critChance += 10 * Dungeon.hero.buff(IntervalWeaponUpgrade.class).boost();
        }
        if (this instanceof MissileWeapon && Dungeon.hero.hasTalent(Talent.CRITICAL_THROW)) {
            critChance += 25 * Dungeon.hero.pointsInTalent(Talent.CRITICAL_THROW);
        }
        if (Dungeon.hero.buff(CertainCrit.class) != null) {
            critChance = 100;
        }
        critChance += Math.round(100.0f * RingOfVorpal.vorpalProc(Dungeon.hero));
        critChance = Math.min(critChance, 100);
        return critChance;
    }

    public int damageRoll(Char owner) {
        if (owner == Dungeon.hero && Dungeon.hero.belongings.weapon() instanceof MeleeWeapon) {
            if (Dungeon.hero.buff(Talent.DetactiveSlashingTracker.class) != null && Dungeon.hero.subClass == HeroSubClass.SLASHER && Dungeon.hero.pointsInTalent(Talent.DETECTIVE_SLASHING) > 2) {
                Buff.affect(Dungeon.hero, SerialAttack.class).maxHit();
            }
            if (this.critChance() > 0) {
                if (Random.Int(100) < this.critChance()) {
                    Demonization demonization;
                    Sample.INSTANCE.play("sounds/hit_strong.mp3");
                    Dungeon.hero.sprite.showStatus(0xFFFF00, "!", new Object[0]);
                    if (Dungeon.hero.buff(Iaido.class) != null && Dungeon.hero.pointsInTalent(Talent.SLASHING) > 1 && Random.Int(7) < Dungeon.hero.buff(Iaido.class).getCount()) {
                        Buff.affect(Dungeon.hero, IntervalWeaponUpgrade.class).levelUp();
                        Item.updateQuickslot();
                    }
                    if ((demonization = owner.buff(Demonization.class)) != null && demonization.isDemonated() && Dungeon.hero.hasTalent(Talent.ENERGY_DRAIN)) {
                        int pointUsed = Dungeon.hero.pointsInTalent(Talent.ENERGY_DRAIN);
                        if (Dungeon.hero.buff(Barrier.class) == null || Dungeon.hero.buff(Barrier.class).shielding() < 10 * pointUsed - pointUsed) {
                            Buff.affect(Dungeon.hero, Barrier.class).incShield(pointUsed);
                        } else {
                            Buff.affect(Dungeon.hero, Barrier.class).setShield(10 * pointUsed);
                        }
                    }
                    if (Dungeon.hero.buff(Flurry.class) != null) {
                        int healAmt = 2;
                        Dungeon.hero.heal(healAmt);
                    }
                    if (Dungeon.hero.pointsInTalent(Talent.JUNG_QUICK_DRAW) > 1 && Dungeon.hero.buff(Jung.class) != null && Dungeon.hero.buff(Sheathing.class) != null) {
                        Buff.prolong(Dungeon.hero, Adrenaline.class, 4.0f);
                    }
                    if (Dungeon.hero.pointsInTalent(Talent.JUNG_QUICK_DRAW) > 2 && Dungeon.hero.buff(Jung.class) != null && Dungeon.hero.buff(Sheathing.class) != null) {
                        Buff.affect(Dungeon.hero, Talent.JungQuickDrawTracker.class);
                    }
                    int damageBonus = 0;
                    if (Dungeon.hero.hasTalent(Talent.JUNG_QUICK_DRAW) && Dungeon.hero.buff(Jung.class) != null && Dungeon.hero.buff(Sheathing.class) != null) {
                        damageBonus += Random.NormalIntRange(0, 20);
                    }
                    return Random.NormalIntRange(Math.round(0.75f * (float)this.max()), this.max()) + damageBonus;
                }
                return Random.NormalIntRange(this.min(), this.max());
            }
            if (Random.Int(100) < -this.critChance()) {
                Dungeon.hero.sprite.showStatus(0xFFFF00, "?", new Object[0]);
                return Random.NormalIntRange(this.min(), Math.round(0.5f * (float)this.max()));
            }
            return Random.NormalIntRange(this.min(), this.max());
        }
        return Random.NormalIntRange(this.min(), this.max());
    }

    public float accuracyFactor(Char owner, Char target) {
        return 1.0f;
    }

    public float delayFactor(Char owner) {
        return 1.0f;
    }

    public int reachFactor(Char owner) {
        return 1;
    }

    public boolean canReach(Char owner, int target) {
        int reach = this.reachFactor(owner);
        SpellBook_Disintegration.ReachBuff buff = Dungeon.hero.buff(SpellBook_Disintegration.ReachBuff.class);
        if (buff != null) {
            reach += 1 + buff.getUpgrade();
        }
        if (Dungeon.level.distance(owner.pos, target) > reach) {
            return false;
        }
        boolean[] passable = BArray.not(Dungeon.level.solid, null);
        for (Char ch : Actor.chars()) {
            if (ch == owner) continue;
            passable[ch.pos] = false;
        }
        PathFinder.buildDistanceMap(target, passable, reach);
        return PathFinder.distance[owner.pos] <= reach;
    }

    public int defenseFactor(Char owner) {
        return 0;
    }

    public int proc(Char attacker, Char defender, int damage) {
        return damage;
    }

    public void hitSound(float pitch) {
        Sample.INSTANCE.play(this.hitSound, 1.0f, pitch * this.hitSoundPitch);
    }
}

