/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class EnergyCrystal
extends Item {
    private static final String TXT_VALUE = "%+d";

    public EnergyCrystal() {
        this(1);
    }

    public EnergyCrystal(int value) {
        this.image = ItemSpriteSheet.ENERGY;
        this.stackable = true;
        this.quantity = value;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        return new ArrayList<String>();
    }

    @Override
    public boolean doPickUp(Hero hero, int pos) {
        Dungeon.energy += this.quantity;
        GameScene.pickUp(this, pos);
        hero.sprite.showStatus(0x44CCFF, TXT_VALUE, this.quantity);
        hero.spendAndNext(1.0f);
        Sample.INSTANCE.play("sounds/item.mp3");
        EnergyCrystal.updateQuickslot();
        return true;
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public Item random() {
        this.quantity = Random.IntRange(4, 6);
        return this;
    }
}

